/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.pointer;

import io.kjson.JSON;
import io.kjson.JSONArray;
import io.kjson.JSONObject;
import io.kjson.JSONValue;
import io.kjson.pointer.JSONPointer;
import io.kjson.pointer.JSONPointerException;
import java.util.Collection;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\n\u001a\u0017\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0086\u0004\u001a\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0004*\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u001a\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0004*\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u001a\u001c\u0010\f\u001a\u00020\r*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000fH\u0000\u001a\u0014\u0010\u0014\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\rH\u0000\u001a\f\u0010\u0016\u001a\u00020\u0012*\u00020\u0002H\u0000\u001a\f\u0010\u0017\u001a\u00020\u0012*\u00020\u0002H\u0000\u001a\f\u0010\u0018\u001a\u00020\u0012*\u00020\u0002H\u0000\u001a\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a \u0010\u001a\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u001c"}, d2={"existsIn", "", "Lio/kjson/pointer/JSONPointer;", "json", "Lio/kjson/JSONValue;", "find", "base", "findOrNull", "findObject", "Lio/kjson/JSONObject;", "findArray", "Lio/kjson/JSONArray;", "checkIndex", "", "token", "", "tokenIndex", "throwInvalidPropertyName", "", "propertyName", "throwInvalidArrayIndex", "index", "throwIntermediateNodeNull", "throwIntermediateNodeNotObjectOrArray", "throwCantDereferenceEndOfArrayPointer", "checkNumber", "locateChild", "target", "kjson-pointer"})
@SourceDebugExtension(value={"SMAP\nFind.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Find.kt\nio/kjson/pointer/FindKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1#2:210\n*E\n"})
public final class FindKt {
    public static final boolean existsIn(@NotNull JSONPointer $this$existsIn, @Nullable JSONValue json) {
        Intrinsics.checkNotNullParameter((Object)$this$existsIn, (String)"<this>");
        JSONValue jSONValue = json;
        if (jSONValue == null) {
            return false;
        }
        JSONValue current = jSONValue;
        int n = $this$existsIn.getDepth();
        for (int i = 0; i < n; ++i) {
            JSONValue jSONValue2;
            String token = $this$existsIn.getToken(i);
            JSONValue jSONValue3 = current;
            if (jSONValue3 instanceof JSONObject) {
                if (!((JSONObject)current).containsKey((Object)token)) {
                    return false;
                }
                jSONValue2 = (JSONValue)((JSONObject)current).get((Object)token);
            } else if (jSONValue3 instanceof JSONArray) {
                if (!FindKt.checkNumber(token)) {
                    return false;
                }
                int index = Integer.parseInt(token);
                if (index < 0 || index >= ((JSONArray)current).size()) {
                    return false;
                }
                jSONValue2 = ((JSONArray)current).get(index);
            } else {
                return false;
            }
            current = jSONValue2;
        }
        return true;
    }

    @Nullable
    public static final JSONValue find(@NotNull JSONPointer $this$find, @Nullable JSONValue base) {
        Intrinsics.checkNotNullParameter((Object)$this$find, (String)"<this>");
        JSONValue result = base;
        int n = $this$find.getDepth();
        for (int i = 0; i < n; ++i) {
            JSONValue jSONValue;
            String token = $this$find.getToken(i);
            JSONValue jSONValue2 = result;
            if (jSONValue2 == null) {
                FindKt.throwIntermediateNodeNull($this$find.truncate(i));
                throw new KotlinNothingValueException();
            }
            if (jSONValue2 instanceof JSONObject) {
                if (!((JSONObject)result).containsKey((Object)token)) {
                    FindKt.throwInvalidPropertyName($this$find.truncate(i), token);
                    throw new KotlinNothingValueException();
                }
                jSONValue = (JSONValue)((JSONObject)result).get((Object)token);
            } else if (jSONValue2 instanceof JSONArray) {
                if (Intrinsics.areEqual((Object)token, (Object)"-")) {
                    FindKt.throwCantDereferenceEndOfArrayPointer($this$find.truncate(i));
                    throw new KotlinNothingValueException();
                }
                int index = FindKt.checkIndex($this$find, token, i);
                if (index < 0 || index >= ((JSONArray)result).size()) {
                    FindKt.throwInvalidArrayIndex($this$find.truncate(i), index);
                    throw new KotlinNothingValueException();
                }
                jSONValue = ((JSONArray)result).get(index);
            } else {
                FindKt.throwIntermediateNodeNotObjectOrArray($this$find.truncate(i));
                throw new KotlinNothingValueException();
            }
            result = jSONValue;
        }
        return result;
    }

    @Nullable
    public static final JSONValue findOrNull(@NotNull JSONPointer $this$findOrNull, @Nullable JSONValue base) {
        Intrinsics.checkNotNullParameter((Object)$this$findOrNull, (String)"<this>");
        JSONValue result = base;
        int n = $this$findOrNull.getDepth();
        for (int i = 0; i < n; ++i) {
            JSONValue jSONValue;
            String token = $this$findOrNull.getToken(i);
            JSONValue jSONValue2 = result;
            if (jSONValue2 instanceof JSONObject) {
                if (!((JSONObject)result).containsKey((Object)token)) {
                    return null;
                }
                jSONValue = (JSONValue)((JSONObject)result).get((Object)token);
            } else if (jSONValue2 instanceof JSONArray) {
                if (!FindKt.checkNumber(token)) {
                    return null;
                }
                int index = Integer.parseInt(token);
                if (index < 0 || index >= ((JSONArray)result).size()) {
                    return null;
                }
                jSONValue = ((JSONArray)result).get(index);
            } else {
                return null;
            }
            result = jSONValue;
        }
        return result;
    }

    @NotNull
    public static final JSONObject findObject(@NotNull JSONPointer $this$findObject, @Nullable JSONValue base) {
        Intrinsics.checkNotNullParameter((Object)$this$findObject, (String)"<this>");
        JSONValue it = FindKt.findOrNull($this$findObject, base);
        boolean bl = false;
        JSONObject jSONObject = it instanceof JSONObject ? (JSONObject)it : null;
        if (jSONObject == null) {
            JSON.typeError$default((JSON)JSON.INSTANCE, (JSONValue)it, (String)"JSONObject", (Object)$this$findObject, null, (int)4, null);
            throw new KotlinNothingValueException();
        }
        return jSONObject;
    }

    @NotNull
    public static final JSONArray findArray(@NotNull JSONPointer $this$findArray, @Nullable JSONValue base) {
        Intrinsics.checkNotNullParameter((Object)$this$findArray, (String)"<this>");
        JSONValue it = FindKt.findOrNull($this$findArray, base);
        boolean bl = false;
        JSONArray jSONArray = it instanceof JSONArray ? (JSONArray)it : null;
        if (jSONArray == null) {
            JSON.typeError$default((JSON)JSON.INSTANCE, (JSONValue)it, (String)"JSONArray", (Object)$this$findArray, null, (int)4, null);
            throw new KotlinNothingValueException();
        }
        return jSONArray;
    }

    private static final int checkIndex(JSONPointer $this$checkIndex, String token, int tokenIndex) {
        if (!FindKt.checkNumber(token)) {
            throw new JSONPointerException("Illegal array index \"" + token + "\" in JSON Pointer", $this$checkIndex.truncate(tokenIndex));
        }
        return Integer.parseInt(token);
    }

    @NotNull
    public static final Void throwInvalidPropertyName(@NotNull JSONPointer $this$throwInvalidPropertyName, @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)$this$throwInvalidPropertyName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        throw new JSONPointerException("Can't locate JSON property \"" + propertyName + '\"', $this$throwInvalidPropertyName);
    }

    @NotNull
    public static final Void throwInvalidArrayIndex(@NotNull JSONPointer $this$throwInvalidArrayIndex, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$throwInvalidArrayIndex, (String)"<this>");
        throw new JSONPointerException("Array index " + index + " out of range in JSON Pointer", $this$throwInvalidArrayIndex);
    }

    @NotNull
    public static final Void throwIntermediateNodeNull(@NotNull JSONPointer $this$throwIntermediateNodeNull) {
        Intrinsics.checkNotNullParameter((Object)$this$throwIntermediateNodeNull, (String)"<this>");
        throw new JSONPointerException("Intermediate node is null", $this$throwIntermediateNodeNull);
    }

    @NotNull
    public static final Void throwIntermediateNodeNotObjectOrArray(@NotNull JSONPointer $this$throwIntermediateNodeNotObjectOrArray) {
        Intrinsics.checkNotNullParameter((Object)$this$throwIntermediateNodeNotObjectOrArray, (String)"<this>");
        throw new JSONPointerException("Intermediate node is not object or array", $this$throwIntermediateNodeNotObjectOrArray);
    }

    @NotNull
    public static final Void throwCantDereferenceEndOfArrayPointer(@NotNull JSONPointer $this$throwCantDereferenceEndOfArrayPointer) {
        Intrinsics.checkNotNullParameter((Object)$this$throwCantDereferenceEndOfArrayPointer, (String)"<this>");
        throw new JSONPointerException("Can't dereference end-of-array JSON Pointer", $this$throwCantDereferenceEndOfArrayPointer);
    }

    public static final boolean checkNumber(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        int len = token.length();
        if (len < 1 || len > 8) {
            return false;
        }
        char ch = token.charAt(0);
        if (ch == '0') {
            return len == 1;
        }
        int i = 1;
        while ('0' <= ch ? ch < ':' : false) {
            if (i >= len) {
                return true;
            }
            ch = token.charAt(i++);
        }
        return false;
    }

    @Nullable
    public static final JSONPointer locateChild(@NotNull JSONPointer $this$locateChild, @Nullable JSONValue base, @Nullable JSONValue target) {
        Intrinsics.checkNotNullParameter((Object)$this$locateChild, (String)"<this>");
        JSONValue jSONValue = base;
        if (jSONValue instanceof JSONObject) {
            if (base == target) {
                return $this$locateChild;
            }
            for (String key : ((JSONObject)base).keySet()) {
                JSONPointer jSONPointer = FindKt.locateChild($this$locateChild.child(key), (JSONValue)((JSONObject)base).get((Object)key), target);
                if (jSONPointer == null) continue;
                JSONPointer it = jSONPointer;
                boolean bl = false;
                return it;
            }
        } else if (jSONValue instanceof JSONArray) {
            if (base == target) {
                return $this$locateChild;
            }
            int n = ((Collection)base).size();
            for (int i = 0; i < n; ++i) {
                JSONPointer jSONPointer = FindKt.locateChild($this$locateChild.child(i), ((JSONArray)base).get(i), target);
                if (jSONPointer == null) continue;
                JSONPointer it = jSONPointer;
                boolean bl = false;
                return it;
            }
        } else if (Intrinsics.areEqual((Object)jSONValue, (Object)target)) {
            return $this$locateChild;
        }
        return null;
    }
}

