/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.pointer;

import io.kjson.JSON;
import io.kjson.JSONArray;
import io.kjson.JSONObject;
import io.kjson.JSONValue;
import io.kjson.pointer.JSONPointer;
import io.kjson.pointer.JSONPointerException;
import io.kjson.pointer.JSONReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.pwall.text.CharMapResult;
import net.pwall.text.MapResult;
import net.pwall.text.StringMapper;
import net.pwall.text.URIStringMapper;
import net.pwall.text.UTF8StringMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0013\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0086\u0004J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017J\u0010\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017J\u0010\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017J\b\u0010\u001f\u001a\u00020\u0010H\u0016J\u001c\u0010 \u001a\u0004\u0018\u00010\u00002\b\u0010!\u001a\u0004\u0018\u00010\u00172\b\u0010\"\u001a\u0004\u0018\u00010\u0017J\u0006\u0010#\u001a\u00020\u0000J\u0013\u0010$\u001a\u00020%2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017H\u0086\u0004J\b\u0010&\u001a\u00020\u0003H\u0016J\u0006\u0010'\u001a\u00020\u0003R\u0013\u0010\b\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006)"}, d2={"Lio/kjson/pointer/JSONPointer;", "", "pointer", "", "(Ljava/lang/String;)V", "tokens", "", "([Ljava/lang/String;)V", "current", "getCurrent", "()Ljava/lang/String;", "getTokens", "()[Ljava/lang/String;", "[Ljava/lang/String;", "child", "index", "", "string", "equals", "", "other", "existsIn", "json", "Lio/kjson/JSONValue;", "find", "base", "findArray", "Lio/kjson/JSONArray;", "findObject", "Lio/kjson/JSONObject;", "findOrNull", "hashCode", "locateChild", "value", "target", "parent", "ref", "Lio/kjson/pointer/JSONReference;", "toString", "toURIFragment", "Companion", "kjson-pointer"})
public final class JSONPointer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] tokens;
    @NotNull
    private static final JSONPointer root;
    @NotNull
    private static final String emptyString = "";
    @NotNull
    private static final CharMapResult mapJSONPointerTilde;
    @NotNull
    private static final CharMapResult mapJSONPointerSlash;

    public JSONPointer(@NotNull String[] tokens) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        this.tokens = tokens;
    }

    @NotNull
    public final String[] getTokens() {
        return this.tokens;
    }

    public JSONPointer(@NotNull String pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        this(Companion.parseString(pointer));
    }

    @Nullable
    public final JSONValue find(@Nullable JSONValue base) {
        return Companion.find(this.tokens, base);
    }

    @Nullable
    public final JSONValue findOrNull(@Nullable JSONValue base) {
        return Companion.findOrNull(this.tokens, base);
    }

    @NotNull
    public final JSONObject findObject(@Nullable JSONValue base) {
        JSONObject jSONObject = JSON.INSTANCE.getAsObjectOrNull(Companion.findOrNull(this.tokens, base));
        if (jSONObject == null) {
            Companion.pointerError$kjson_pointer("JSON Pointer does not point to object", this.toString());
            throw new KotlinNothingValueException();
        }
        return jSONObject;
    }

    @NotNull
    public final JSONArray findArray(@Nullable JSONValue base) {
        JSONArray jSONArray = JSON.INSTANCE.getAsArrayOrNull(Companion.findOrNull(this.tokens, base));
        if (jSONArray == null) {
            Companion.pointerError$kjson_pointer("JSON Pointer does not point to array", this.toString());
            throw new KotlinNothingValueException();
        }
        return jSONArray;
    }

    public final boolean existsIn(@Nullable JSONValue json) {
        return Companion.existsIn(this.tokens, json);
    }

    @NotNull
    public final JSONPointer parent() {
        JSONPointer jSONPointer;
        int len = this.tokens.length;
        switch (len) {
            case 0: {
                throw new JSONPointerException("Can't get parent of root JSON Pointer");
            }
            case 1: {
                jSONPointer = root;
                break;
            }
            default: {
                int n = 0;
                int n2 = len - 1;
                String[] stringArray = new String[n2];
                while (n < n2) {
                    int n3 = n++;
                    stringArray[n3] = this.tokens[n3];
                }
                String[] stringArray2 = stringArray;
                jSONPointer = new JSONPointer(stringArray2);
            }
        }
        return jSONPointer;
    }

    @NotNull
    public final JSONPointer child(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int len = this.tokens.length;
        int n = len + 1;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            stringArray[n2] = n2 < len ? this.tokens[n2] : string;
        }
        String[] stringArray2 = stringArray;
        return new JSONPointer(stringArray2);
    }

    @NotNull
    public final JSONPointer child(int index) {
        if (index < 0) {
            throw new JSONPointerException("JSON Pointer index must not be negative");
        }
        return this.child(String.valueOf(index));
    }

    @Nullable
    public final String getCurrent() {
        return this.tokens.length == 0 ? null : this.tokens[this.tokens.length - 1];
    }

    @NotNull
    public final String toURIFragment() {
        StringBuilder stringBuilder;
        StringBuilder $this$toURIFragment_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toURIFragment_u24lambda_u2d0.append('#');
        for (String token : this.getTokens()) {
            $this$toURIFragment_u24lambda_u2d0.append('/');
            $this$toURIFragment_u24lambda_u2d0.append(URIStringMapper.INSTANCE.encodeURI(UTF8StringMapper.INSTANCE.encodeUTF8(Companion.encodeJSONPointer(token))));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Nullable
    public final JSONPointer locateChild(@Nullable JSONValue value, @Nullable JSONValue target) {
        block4: {
            block3: {
                if (value == target) {
                    return this;
                }
                if (!(value instanceof JSONObject)) break block3;
                for (String key : ((JSONObject)value).keySet()) {
                    JSONPointer jSONPointer = this.child(key).locateChild((JSONValue)((JSONObject)value).get((Object)key), target);
                    if (jSONPointer == null) continue;
                    JSONPointer it = jSONPointer;
                    boolean bl = false;
                    return it;
                }
                break block4;
            }
            if (!(value instanceof JSONArray)) break block4;
            int n = 0;
            int n2 = ((JSONArray)value).size();
            while (n < n2) {
                int i = n++;
                JSONPointer jSONPointer = this.child(i).locateChild(((JSONArray)value).get(i), target);
                if (jSONPointer == null) continue;
                JSONPointer it = jSONPointer;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    @NotNull
    public final JSONReference ref(@Nullable JSONValue base) {
        return Companion.existsIn(this.tokens, base) ? new JSONReference(base, this.tokens, true, Companion.find(this.tokens, base)) : new JSONReference(base, this.tokens, false, null);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof JSONPointer && Arrays.equals(this.tokens, ((JSONPointer)other).tokens);
    }

    public int hashCode() {
        return Arrays.hashCode(this.tokens);
    }

    @NotNull
    public String toString() {
        return Companion.toString(this.tokens, this.tokens.length);
    }

    public static final /* synthetic */ CharMapResult access$getMapJSONPointerTilde$cp() {
        return mapJSONPointerTilde;
    }

    public static final /* synthetic */ CharMapResult access$getMapJSONPointerSlash$cp() {
        return mapJSONPointerSlash;
    }

    static {
        boolean $i$f$emptyArray = false;
        root = new JSONPointer(new String[0]);
        mapJSONPointerTilde = new CharMapResult(2, '~');
        mapJSONPointerSlash = new CharMapResult(2, '/');
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0001\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0015J#\u0010\u0016\u001a\u00020\u00142\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J%\u0010\u001b\u001a\u0004\u0018\u00010\u00182\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u001cJ\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J%\u0010\u001e\u001a\u0004\u0018\u00010\u00182\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u001cJ\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u000e\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u0004J\u0019\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\"J-\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0000\u00a2\u0006\u0004\b&\u0010'J\u001d\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b&J!\u0010(\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010)\u001a\u00020\r\u00a2\u0006\u0002\u0010*J\n\u0010+\u001a\u00020\u0004*\u00020\u0004J\n\u0010,\u001a\u00020\u0004*\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006-"}, d2={"Lio/kjson/pointer/JSONPointer$Companion;", "", "()V", "emptyString", "", "mapJSONPointerSlash", "Lnet/pwall/text/CharMapResult;", "mapJSONPointerTilde", "root", "Lio/kjson/pointer/JSONPointer;", "getRoot", "()Lio/kjson/pointer/JSONPointer;", "checkIndex", "", "token", "tokens", "", "tokenIndex", "(Ljava/lang/String;[Ljava/lang/String;I)I", "checkNumber", "", "checkNumber$kjson_pointer", "existsIn", "base", "Lio/kjson/JSONValue;", "([Ljava/lang/String;Lio/kjson/JSONValue;)Z", "string", "find", "([Ljava/lang/String;Lio/kjson/JSONValue;)Lio/kjson/JSONValue;", "pointer", "findOrNull", "fromURIFragment", "fragment", "parseString", "(Ljava/lang/String;)[Ljava/lang/String;", "pointerError", "", "mainText", "pointerError$kjson_pointer", "(Ljava/lang/String;[Ljava/lang/String;I)Ljava/lang/Void;", "toString", "n", "([Ljava/lang/String;I)Ljava/lang/String;", "decodeJSONPointer", "encodeJSONPointer", "kjson-pointer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JSONPointer getRoot() {
            return root;
        }

        @Nullable
        public final JSONValue find(@NotNull String pointer, @Nullable JSONValue base) {
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            return this.find(this.parseString(pointer), base);
        }

        @Nullable
        public final JSONValue find(@NotNull String[] tokens, @Nullable JSONValue base) {
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            JSONValue result = base;
            int n = 0;
            int n2 = tokens.length;
            while (n < n2) {
                JSONValue jSONValue;
                int i = n++;
                String token = tokens[i];
                JSONValue jSONValue2 = result;
                if (jSONValue2 instanceof JSONObject) {
                    if (!((JSONObject)result).containsKey((Object)token)) {
                        this.pointerError$kjson_pointer("Can't resolve JSON Pointer", tokens, i + 1);
                        throw new KotlinNothingValueException();
                    }
                    jSONValue = (JSONValue)((JSONObject)result).get((Object)token);
                } else if (jSONValue2 instanceof JSONArray) {
                    if (Intrinsics.areEqual((Object)token, (Object)"-")) {
                        this.pointerError$kjson_pointer("Can't dereference end-of-array JSON Pointer", tokens, i + 1);
                        throw new KotlinNothingValueException();
                    }
                    int index = this.checkIndex(token, tokens, i + 1);
                    if (index < 0 || index >= ((JSONArray)result).size()) {
                        this.pointerError$kjson_pointer("Array index out of range in JSON Pointer", tokens, i + 1);
                        throw new KotlinNothingValueException();
                    }
                    jSONValue = ((JSONArray)result).get(index);
                } else {
                    this.pointerError$kjson_pointer("Can't resolve JSON Pointer", tokens, i + 1);
                    throw new KotlinNothingValueException();
                }
                result = jSONValue;
            }
            return result;
        }

        @Nullable
        public final JSONValue findOrNull(@NotNull String pointer, @Nullable JSONValue base) {
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            return this.findOrNull(this.parseString(pointer), base);
        }

        @Nullable
        public final JSONValue findOrNull(@NotNull String[] tokens, @Nullable JSONValue base) {
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            JSONValue result = base;
            int n = 0;
            int n2 = tokens.length;
            while (n < n2) {
                JSONValue jSONValue;
                int i = n++;
                String token = tokens[i];
                JSONValue jSONValue2 = result;
                if (jSONValue2 instanceof JSONObject) {
                    if (!((JSONObject)result).containsKey((Object)token)) {
                        return null;
                    }
                    jSONValue = (JSONValue)((JSONObject)result).get((Object)token);
                } else if (jSONValue2 instanceof JSONArray) {
                    if (!this.checkNumber$kjson_pointer(token)) {
                        return null;
                    }
                    int index = Integer.parseInt(token);
                    if (index < 0 || index >= ((JSONArray)result).size()) {
                        return null;
                    }
                    jSONValue = ((JSONArray)result).get(index);
                } else {
                    return null;
                }
                result = jSONValue;
            }
            return result;
        }

        public final boolean existsIn(@NotNull String string, @Nullable JSONValue base) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return this.existsIn(this.parseString(string), base);
        }

        public final boolean existsIn(@NotNull String[] tokens, @Nullable JSONValue base) {
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            JSONValue jSONValue = base;
            if (jSONValue == null) {
                return false;
            }
            JSONValue current = jSONValue;
            int n = 0;
            int n2 = tokens.length;
            while (n < n2) {
                JSONValue jSONValue2;
                String token = tokens[n];
                ++n;
                JSONValue jSONValue3 = current;
                if (jSONValue3 instanceof JSONObject) {
                    if (!((JSONObject)current).containsKey((Object)token)) {
                        return false;
                    }
                    jSONValue2 = (JSONValue)((JSONObject)current).get((Object)token);
                } else if (jSONValue3 instanceof JSONArray) {
                    if (!this.checkNumber$kjson_pointer(token)) {
                        return false;
                    }
                    int index = Integer.parseInt(token);
                    if (index < 0 || index >= ((JSONArray)current).size()) {
                        return false;
                    }
                    jSONValue2 = ((JSONArray)current).get(index);
                } else {
                    return false;
                }
                current = jSONValue2;
            }
            return true;
        }

        private final int checkIndex(String token, String[] tokens, int tokenIndex) {
            if (!this.checkNumber$kjson_pointer(token)) {
                this.pointerError$kjson_pointer("Illegal array index in JSON Pointer", tokens, tokenIndex);
                throw new KotlinNothingValueException();
            }
            return Integer.parseInt(token);
        }

        public final boolean checkNumber$kjson_pointer(@NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            int len = token.length();
            if (len < 1 || len > 8) {
                return false;
            }
            char ch = token.charAt(0);
            if (ch == '0') {
                return len == 1;
            }
            int i = 1;
            while ('0' <= ch ? ch < ':' : false) {
                if (i >= len) {
                    return true;
                }
                int n = i;
                i = n + 1;
                ch = token.charAt(n);
            }
            return false;
        }

        @NotNull
        public final String toString(@NotNull String[] tokens, int n) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            if (n == 0) {
                return JSONPointer.emptyString;
            }
            StringBuilder $this$toString_u24lambda_u2d0 = stringBuilder = new StringBuilder();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                int i = n2++;
                $this$toString_u24lambda_u2d0.append('/');
                $this$toString_u24lambda_u2d0.append(Companion.encodeJSONPointer(tokens[i]));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String[] parseString(@NotNull String string) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            if (((CharSequence)string).length() == 0) {
                boolean $i$f$emptyArray = false;
                return new String[0];
            }
            if (string.charAt(0) != '/') {
                this.pointerError$kjson_pointer("Illegal JSON Pointer", string);
                throw new KotlinNothingValueException();
            }
            Object object = string.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).substring(startIndex)");
            char[] $i$f$emptyArray = new char[]{'/'};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])$i$f$emptyArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string2;
                void it;
                String string3 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                try {
                    string2 = Companion.decodeJSONPointer((String)it);
                }
                catch (Exception e) {
                    Companion.pointerError$kjson_pointer("Illegal token in JSON Pointer", (String)it);
                    throw new KotlinNothingValueException();
                }
                collection.add(string2);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            return stringArray;
        }

        @NotNull
        public final JSONPointer fromURIFragment(@NotNull String fragment) {
            String string;
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            if (((CharSequence)fragment).length() == 0 || fragment.charAt(0) != '#') {
                this.pointerError$kjson_pointer("Illegal URI fragment", fragment);
                throw new KotlinNothingValueException();
            }
            try {
                String string2 = fragment.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                string = UTF8StringMapper.INSTANCE.decodeUTF8(URIStringMapper.INSTANCE.decodeURI(string2));
            }
            catch (Exception e) {
                this.pointerError$kjson_pointer("Illegal URI fragment", fragment);
                throw new KotlinNothingValueException();
            }
            String pointer = string;
            return new JSONPointer(pointer);
        }

        @NotNull
        public final Void pointerError$kjson_pointer(@NotNull String mainText, @NotNull String[] tokens, int tokenIndex) {
            Intrinsics.checkNotNullParameter((Object)mainText, (String)"mainText");
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            this.pointerError$kjson_pointer(mainText, this.toString(tokens, tokenIndex));
            throw new KotlinNothingValueException();
        }

        @NotNull
        public final Void pointerError$kjson_pointer(@NotNull String mainText, @NotNull String pointer) {
            Intrinsics.checkNotNullParameter((Object)mainText, (String)"mainText");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            throw new JSONPointerException(mainText + " - \"" + pointer + '\"');
        }

        @NotNull
        public final String encodeJSONPointer(@NotNull String $this$encodeJSONPointer) {
            Intrinsics.checkNotNullParameter((Object)$this$encodeJSONPointer, (String)"<this>");
            return StringMapper.INSTANCE.mapCharacters($this$encodeJSONPointer, (Function1)encodeJSONPointer.1.INSTANCE);
        }

        @NotNull
        public final String decodeJSONPointer(@NotNull String $this$decodeJSONPointer) {
            Intrinsics.checkNotNullParameter((Object)$this$decodeJSONPointer, (String)"<this>");
            return StringMapper.INSTANCE.mapSubstrings($this$decodeJSONPointer, (Function1)new Function1<Integer, MapResult>($this$decodeJSONPointer){
                final /* synthetic */ String $this_decodeJSONPointer;
                {
                    this.$this_decodeJSONPointer = $receiver;
                    super(1);
                }

                @Nullable
                public final MapResult invoke(int index) {
                    MapResult mapResult;
                    if (this.$this_decodeJSONPointer.charAt(index) == '~') {
                        CharMapResult charMapResult;
                        StringMapper.checkLength$default((StringMapper)StringMapper.INSTANCE, (String)this.$this_decodeJSONPointer, (int)index, (int)2, null, (int)8, null);
                        char c = this.$this_decodeJSONPointer.charAt(index + 1);
                        if (c == '0') {
                            charMapResult = JSONPointer.access$getMapJSONPointerTilde$cp();
                        } else if (c == '1') {
                            charMapResult = JSONPointer.access$getMapJSONPointerSlash$cp();
                        } else {
                            throw new IllegalArgumentException("Invalid escape sequence");
                        }
                        mapResult = (MapResult)charMapResult;
                    } else {
                        mapResult = null;
                    }
                    return mapResult;
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

