/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.pointer;

import io.kjson.JSON;
import io.kjson.JSONArray;
import io.kjson.JSONObject;
import io.kjson.JSONValue;
import io.kjson.pointer.JSONPointer;
import io.kjson.pointer.JSONPointerException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B1\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0007J\u0013\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0007J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00002\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u001f\u001a\u00020\u0000J\b\u0010 \u001a\u00020\u0007H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006!"}, d2={"Lio/kjson/pointer/JSONReference;", "", "base", "Lio/kjson/JSONValue;", "(Lio/kjson/JSONValue;)V", "tokens", "", "", "valid", "", "value", "(Lio/kjson/JSONValue;[Ljava/lang/String;ZLio/kjson/JSONValue;)V", "getBase", "()Lio/kjson/JSONValue;", "pointer", "Lio/kjson/pointer/JSONPointer;", "getPointer", "()Lio/kjson/pointer/JSONPointer;", "getValid", "()Z", "getValue", "child", "index", "", "name", "equals", "other", "hasChild", "hashCode", "locateChild", "target", "parent", "toString", "kjson-pointer"})
public final class JSONReference {
    @Nullable
    private final JSONValue base;
    private final boolean valid;
    @Nullable
    private final JSONValue value;
    @NotNull
    private final JSONPointer pointer;

    public JSONReference(@Nullable JSONValue base, @NotNull String[] tokens, boolean valid, @Nullable JSONValue value) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        this.base = base;
        this.valid = valid;
        this.value = value;
        this.pointer = new JSONPointer(tokens);
    }

    @Nullable
    public final JSONValue getBase() {
        return this.base;
    }

    public final boolean getValid() {
        return this.valid;
    }

    @Nullable
    public final JSONValue getValue() {
        return this.value;
    }

    public JSONReference(@Nullable JSONValue base) {
        boolean $i$f$emptyArray = false;
        this(base, new String[]{}, base != null, base);
    }

    @NotNull
    public final JSONPointer getPointer() {
        return this.pointer;
    }

    public final boolean hasChild(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.valid && this.value instanceof JSONObject && ((JSONObject)this.value).containsKey((Object)name);
    }

    public final boolean hasChild(int index) {
        return this.valid && (this.value instanceof JSONArray && index < ((JSONArray)this.value).size() || this.value instanceof JSONObject && ((JSONObject)this.value).containsKey((Object)String.valueOf(index)));
    }

    @NotNull
    public final JSONReference parent() {
        String[] tokens = this.pointer.getTokens();
        int len = tokens.length;
        if (len == 0) {
            throw new JSONPointerException("Can't get parent of root JSON Pointer");
        }
        int n = 0;
        int n2 = len - 1;
        String[] stringArray = new String[n2];
        while (n < n2) {
            int n3 = n++;
            stringArray[n3] = tokens[n3];
        }
        String[] newArray = stringArray;
        return new JSONReference(this.base, newArray, true, JSONPointer.Companion.find(newArray, this.base));
    }

    @NotNull
    public final JSONReference child(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] tokens = this.pointer.getTokens();
        int len = tokens.length;
        int n = len + 1;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            stringArray[n2] = n2 < len ? tokens[n2] : name;
        }
        String[] newArray = stringArray;
        return this.valid && this.value instanceof JSONObject && ((JSONObject)this.value).containsKey((Object)name) ? new JSONReference(this.base, newArray, true, (JSONValue)((JSONObject)this.value).get((Object)name)) : new JSONReference(this.base, newArray, false, null);
    }

    @NotNull
    public final JSONReference child(int index) {
        if (index < 0) {
            throw new JSONPointerException("JSON Pointer index must not be negative");
        }
        String[] tokens = this.pointer.getTokens();
        int len = tokens.length;
        String name = String.valueOf(index);
        int n = len + 1;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            stringArray[n2] = n2 < len ? tokens[n2] : name;
        }
        String[] newArray = stringArray;
        if (this.valid) {
            if (this.value instanceof JSONArray) {
                if (index < ((JSONArray)this.value).size()) {
                    return new JSONReference(this.base, newArray, true, ((JSONArray)this.value).get(index));
                }
            } else if (this.value instanceof JSONObject && ((JSONObject)this.value).containsKey((Object)name)) {
                return new JSONReference(this.base, newArray, true, (JSONValue)((JSONObject)this.value).get((Object)name));
            }
        }
        return new JSONReference(this.base, newArray, false, null);
    }

    @Nullable
    public final JSONReference locateChild(@Nullable JSONValue target) {
        block4: {
            block3: {
                if (this.value == target) {
                    return this;
                }
                if (!(this.value instanceof JSONObject)) break block3;
                for (String key : ((JSONObject)this.value).keySet()) {
                    JSONReference jSONReference = this.child(key).locateChild(target);
                    if (jSONReference == null) continue;
                    JSONReference it = jSONReference;
                    boolean bl = false;
                    return it;
                }
                break block4;
            }
            if (!(this.value instanceof JSONArray)) break block4;
            int n = 0;
            int n2 = ((JSONArray)this.value).size();
            while (n < n2) {
                int i = n++;
                JSONReference jSONReference = this.child(i).locateChild(target);
                if (jSONReference == null) continue;
                JSONReference it = jSONReference;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof JSONReference && this.base == ((JSONReference)other).base && this.valid == ((JSONReference)other).valid && this.value == ((JSONReference)other).value && Intrinsics.areEqual((Object)this.pointer, (Object)((JSONReference)other).pointer);
    }

    public int hashCode() {
        JSONValue jSONValue = this.base;
        JSONValue jSONValue2 = this.value;
        return (jSONValue == null ? 0 : jSONValue.hashCode()) ^ Boolean.hashCode(this.valid) ^ (jSONValue2 == null ? 0 : jSONValue2.hashCode()) ^ this.pointer.hashCode();
    }

    @NotNull
    public String toString() {
        return this.valid ? JSON.INSTANCE.toJSON(this.value) : "invalid";
    }
}

