/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.util;

import io.kjson.JSONStructure;
import io.kjson.util.BuilderException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0019\u0012\u0010\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004H\u0004\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00018\u0000H\u0004\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\tH\u0004J\b\u0010\u0015\u001a\u00020\u0010H\u0004J\f\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H&R\u001a\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lio/kjson/util/AbstractBuilder;", "T", "", "array", "", "<init>", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "count", "", "size", "getSize", "()I", "checkArray", "()[Ljava/lang/Object;", "internalAdd", "", "value", "(Ljava/lang/Object;)V", "internalRemove", "index", "invalidate", "build", "Lio/kjson/JSONStructure;", "kjson-core"})
public abstract class AbstractBuilder<T> {
    @Nullable
    private T[] array;
    private int count;

    public AbstractBuilder(@Nullable T[] array) {
        this.array = array;
    }

    public final int getSize() {
        return this.count;
    }

    @NotNull
    protected final T[] checkArray() {
        if (this.array == null) {
            throw new BuilderException("Builder is closed", null, 2, null);
        }
        return this.array;
    }

    protected final void internalAdd(@Nullable T value) {
        T[] validArray = this.checkArray();
        int len = validArray.length;
        if (this.count >= len) {
            T[] TArray = Arrays.copyOf(validArray, len + RangesKt.coerceAtMost((int)len, (int)4096));
            Intrinsics.checkNotNullExpressionValue(TArray, (String)"copyOf(...)");
            validArray = TArray;
            this.array = validArray;
        }
        int n = this.count;
        this.count = n + 1;
        validArray[n] = value;
    }

    protected final void internalRemove(int index) {
        T[] validArray = this.checkArray();
        System.arraycopy(validArray, index + 1, validArray, index, this.count - index);
        int n = this.count;
        this.count = n + -1;
    }

    protected final void invalidate() {
        this.array = null;
    }

    @NotNull
    public abstract JSONStructure<?> build();
}

