/*
 * Decompiled with CFR 0.152.
 */
package io.kjson;

import io.kjson.JSONDecimal;
import io.kjson.JSONInt;
import io.kjson.JSONNumberValue;
import io.kjson.JSONValue;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.JSONFunctions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0012H\u0016J\b\u0010#\u001a\u00020\u0004H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006)"}, d2={"Lio/kjson/JSONLong;", "Lio/kjson/JSONNumberValue;", "Lio/kjson/JSONValue;", "value", "", "(J)V", "getValue", "()Ljava/lang/Long;", "appendTo", "", "a", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "equals", "", "other", "", "hashCode", "", "isByte", "isInt", "isIntegral", "isLong", "isShort", "toByte", "", "toChar", "", "toDecimal", "Ljava/math/BigDecimal;", "toDouble", "", "toFloat", "", "toInt", "toLong", "toShort", "", "toString", "", "Companion", "kjson-core"})
public final class JSONLong
extends JSONNumberValue
implements JSONValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long value;
    @NotNull
    private static final JSONLong ZERO = new JSONLong(0L);

    public JSONLong(long value) {
        this.value = value;
    }

    @Override
    @NotNull
    public Long getValue() {
        return this.value;
    }

    @Override
    public void appendTo(@NotNull Appendable a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        JSONFunctions.appendLong((Appendable)a, (long)this.getValue());
    }

    @Override
    public boolean isIntegral() {
        return true;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public boolean isInt() {
        long l = this.getValue();
        return Integer.MIN_VALUE <= l ? l <= Integer.MAX_VALUE : false;
    }

    @Override
    public boolean isShort() {
        long l = this.getValue();
        return -32768L <= l ? l <= 32767L : false;
    }

    @Override
    public boolean isByte() {
        long l = this.getValue();
        return -128L <= l ? l <= 127L : false;
    }

    @Override
    public double toDouble() {
        return this.getValue().longValue();
    }

    @Override
    public float toFloat() {
        return this.getValue().longValue();
    }

    @Override
    public long toLong() {
        return this.getValue();
    }

    @Override
    public int toInt() {
        return (int)this.getValue().longValue();
    }

    public char toChar() {
        return (char)this.getValue().longValue();
    }

    @Override
    public short toShort() {
        return (short)this.getValue().longValue();
    }

    @Override
    public byte toByte() {
        return (byte)this.getValue().longValue();
    }

    @Override
    @NotNull
    public BigDecimal toDecimal() {
        return new BigDecimal(this.getValue());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSONValue)) {
            return false;
        }
        JSONValue jSONValue = (JSONValue)other;
        return jSONValue instanceof JSONInt ? this.getValue() == (long)((JSONInt)other).getValue().intValue() : (jSONValue instanceof JSONLong ? this.getValue().longValue() == ((JSONLong)other).getValue().longValue() : (jSONValue instanceof JSONDecimal ? new BigDecimal(this.getValue()).compareTo(((JSONDecimal)other).getValue()) == 0 : false));
    }

    public int hashCode() {
        return (int)this.getValue().longValue();
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.getValue());
    }

    @Override
    @NotNull
    public String toJSON() {
        return JSONValue.DefaultImpls.toJSON(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lio/kjson/JSONLong$Companion;", "", "()V", "ZERO", "Lio/kjson/JSONLong;", "getZERO", "()Lio/kjson/JSONLong;", "of", "i", "", "kjson-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JSONLong getZERO() {
            return ZERO;
        }

        @NotNull
        public final JSONLong of(long i) {
            return i == 0L ? this.getZERO() : new JSONLong(i);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

