/*
 * Decompiled with CFR 0.152.
 */
package io.karatelabs.debug;

import com.intuit.karate.core.Step;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class Breakpoint {
    private static final AtomicInteger NEXT = new AtomicInteger();
    public final int id = NEXT.incrementAndGet();
    public final int line;
    public final boolean verified;
    public final String condition;

    public Breakpoint(Map<String, Object> map) {
        this.line = (Integer)map.get("line");
        this.verified = true;
        String breakpointCondition = (String)map.get("condition");
        if (breakpointCondition != null) {
            String conditionText = breakpointCondition.trim();
            for (String prefix : Step.PREFIXES) {
                if (!conditionText.startsWith(prefix)) continue;
                conditionText = conditionText.substring(prefix.length());
                break;
            }
            if ((conditionText = conditionText.trim()).startsWith("\"\"\"") && conditionText.endsWith("\"\"\"")) {
                conditionText = conditionText.substring("\"\"\"".length());
                conditionText = conditionText.substring(0, conditionText.length() - "\"\"\"".length());
            }
            this.condition = conditionText.trim();
        } else {
            this.condition = null;
        }
    }

    public int getId() {
        return this.id;
    }

    public int getLine() {
        return this.line;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.id);
        map.put("line", this.line);
        map.put("verified", this.verified);
        return map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[id: ").append(this.id);
        sb.append(", line: ").append(this.line);
        sb.append(", verified: ").append(this.verified);
        sb.append("]");
        return sb.toString();
    }
}

