/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String name;

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r, String.format("kamon-agent-" + this.name + "-%s", this.threadNumber.getAndIncrement()));
        thread.setDaemon(true);
        return thread;
    }

    private NamedThreadFactory(String name) {
        this.name = name;
    }

    public static NamedThreadFactory instance(String name) {
        return new NamedThreadFactory(name);
    }

    public AtomicInteger getThreadNumber() {
        return this.threadNumber;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NamedThreadFactory)) {
            return false;
        }
        NamedThreadFactory other = (NamedThreadFactory)o;
        AtomicInteger this$threadNumber = this.getThreadNumber();
        AtomicInteger other$threadNumber = other.getThreadNumber();
        if (this$threadNumber == null ? other$threadNumber != null : !this$threadNumber.equals(other$threadNumber)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AtomicInteger $threadNumber = this.getThreadNumber();
        result = result * 59 + ($threadNumber == null ? 43 : $threadNumber.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "NamedThreadFactory(threadNumber=" + this.getThreadNumber() + ", name=" + this.getName() + ")";
    }
}

