/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.broker;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kanela.agent.broker.Subscribe;

public final class EventBroker {
    private final Map<Class, List<SubscriberInfo>> map = new LinkedHashMap<Class, List<SubscriberInfo>>();

    public static EventBroker instance() {
        return Holder.Instance;
    }

    public int publish(Object o) {
        List<SubscriberInfo> subscriberInfos = this.map.get(o.getClass());
        if (subscriberInfos == null) {
            return 0;
        }
        int count = 0;
        for (SubscriberInfo subscriberInfo : subscriberInfos) {
            subscriberInfo.invoke(o);
            ++count;
        }
        return count;
    }

    public void add(Object o) {
        for (Method method : o.getClass().getMethods()) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (method.getAnnotation(Subscribe.class) == null || parameterTypes.length != 1) continue;
            Class<?> subscribeTo = parameterTypes[0];
            List subscribers = this.map.computeIfAbsent(subscribeTo, k -> new ArrayList());
            subscribers.add(new SubscriberInfo(method, o));
        }
    }

    public void remove(Object o) {
        for (List<SubscriberInfo> subscriberInfos : this.map.values()) {
            for (int i = subscriberInfos.size() - 1; i >= 0; --i) {
                if (subscriberInfos.get(i).object != o) continue;
                subscriberInfos.remove(i);
            }
        }
    }

    public Map<Class, List<SubscriberInfo>> getMap() {
        return this.map;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventBroker)) {
            return false;
        }
        EventBroker other = (EventBroker)o;
        Map<Class, List<SubscriberInfo>> this$map = this.getMap();
        Map<Class, List<SubscriberInfo>> other$map = other.getMap();
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Class, List<SubscriberInfo>> $map = this.getMap();
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }

    public String toString() {
        return "EventBroker(map=" + this.getMap() + ")";
    }

    static final class SubscriberInfo {
        private final Method method;
        private final Object object;

        void invoke(Object o) {
            try {
                this.method.invoke(this.object, o);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }

        public SubscriberInfo(Method method, Object object) {
            this.method = method;
            this.object = object;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getObject() {
            return this.object;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubscriberInfo)) {
                return false;
            }
            SubscriberInfo other = (SubscriberInfo)o;
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
                return false;
            }
            Object this$object = this.getObject();
            Object other$object = other.getObject();
            return !(this$object == null ? other$object != null : !this$object.equals(other$object));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            Object $object = this.getObject();
            result = result * 59 + ($object == null ? 43 : $object.hashCode());
            return result;
        }

        public String toString() {
            return "EventBroker.SubscriberInfo(method=" + this.getMethod() + ", object=" + this.getObject() + ")";
        }
    }

    private static class Holder {
        private static final EventBroker Instance = new EventBroker();

        private Holder() {
        }
    }
}

