/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.api.instrumentation.bridge;

import java.lang.annotation.Annotation;
import kanela.agent.api.instrumentation.bridge.Bridge;
import kanela.agent.api.instrumentation.bridge.BridgeDescription;
import kanela.agent.api.instrumentation.bridge.FieldBridge;
import kanela.agent.libs.net.bytebuddy.jar.asm.ClassVisitor;
import kanela.agent.libs.net.bytebuddy.jar.asm.MethodVisitor;
import kanela.agent.libs.net.bytebuddy.jar.asm.Type;
import kanela.agent.libs.net.bytebuddy.jar.asm.commons.Method;
import kanela.agent.libs.net.bytebuddy.utility.OpenedClassReader;

public final class BridgeClassVisitor
extends ClassVisitor {
    private final BridgeDescription bridge;
    private final Type type;

    public static BridgeClassVisitor from(BridgeDescription bridge, String className, ClassVisitor classVisitor) {
        return new BridgeClassVisitor(bridge, className, classVisitor);
    }

    private BridgeClassVisitor(BridgeDescription bridge, String className, ClassVisitor classVisitor) {
        super(OpenedClassReader.ASM_API, classVisitor);
        this.bridge = bridge;
        this.type = Type.getObjectType(className);
    }

    @Override
    public void visitEnd() {
        this.bridge.getMethods().forEach(reflectMethod -> {
            for (Annotation annotation : reflectMethod.getDeclaredAnnotations()) {
                if (annotation instanceof Bridge) {
                    this.processBridge((java.lang.reflect.Method)reflectMethod, annotation);
                    continue;
                }
                if (!(annotation instanceof FieldBridge)) continue;
                this.processFieldBridge((java.lang.reflect.Method)reflectMethod, annotation);
            }
        });
        this.cv.visitEnd();
    }

    private void processBridge(java.lang.reflect.Method reflectMethod, Annotation annotation) {
        Bridge bridge = (Bridge)annotation;
        Method method = Method.getMethod(reflectMethod);
        Method targetMethod = Method.getMethod(bridge.value());
        MethodVisitor mv = this.cv.visitMethod(1, method.getName(), method.getDescriptor(), null, null);
        mv.visitCode();
        int i = 0;
        mv.visitVarInsn(25, i++);
        for (Type argument : method.getArgumentTypes()) {
            mv.visitVarInsn(argument.getOpcode(21), i++);
        }
        mv.visitMethodInsn(182, this.type.getInternalName(), targetMethod.getName(), targetMethod.getDescriptor(), false);
        mv.visitInsn(method.getReturnType().getOpcode(172));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void processFieldBridge(java.lang.reflect.Method reflectMethod, Annotation annotation) {
        FieldBridge fieldBridge = (FieldBridge)annotation;
        Method method = Method.getMethod(reflectMethod);
        MethodVisitor mv = this.cv.visitMethod(1, method.getName(), method.getDescriptor(), null, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.type.getInternalName(), fieldBridge.value(), method.getReturnType().getDescriptor());
        mv.visitInsn(Type.getType(this.type.getDescriptor()).getOpcode(172));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public BridgeDescription getBridge() {
        return this.bridge;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "BridgeClassVisitor(bridge=" + this.getBridge() + ", type=" + this.getType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BridgeClassVisitor)) {
            return false;
        }
        BridgeClassVisitor other = (BridgeClassVisitor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BridgeDescription this$bridge = this.getBridge();
        BridgeDescription other$bridge = other.getBridge();
        if (this$bridge == null ? other$bridge != null : !((Object)this$bridge).equals(other$bridge)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BridgeClassVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BridgeDescription $bridge = this.getBridge();
        result = result * 59 + ($bridge == null ? 43 : ((Object)$bridge).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        return result;
    }
}

