/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.api.instrumentation;

import java.lang.annotation.Annotation;
import java.lang.instrument.Instrumentation;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import kanela.agent.api.advisor.AdvisorDescription;
import kanela.agent.api.instrumentation.InstrumentationDescription;
import kanela.agent.api.instrumentation.TypeTransformation;
import kanela.agent.api.instrumentation.bridge.BridgeDescription;
import kanela.agent.api.instrumentation.classloader.ClassLoaderRefiner;
import kanela.agent.api.instrumentation.classloader.ClassRefiner;
import kanela.agent.api.instrumentation.legacy.ClassFileVersionValidatorTransformer;
import kanela.agent.api.instrumentation.mixin.MixinDescription;
import kanela.agent.libs.io.vavr.Function0;
import kanela.agent.libs.net.bytebuddy.agent.builder.AgentBuilder;
import kanela.agent.libs.net.bytebuddy.description.ByteCodeElement;
import kanela.agent.libs.net.bytebuddy.description.method.MethodDescription;
import kanela.agent.libs.net.bytebuddy.description.type.TypeDescription;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatcher;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatchers;
import kanela.agent.util.BootstrapInjector;
import kanela.agent.util.ListBuilder;
import kanela.agent.util.conf.KanelaConfiguration;

public abstract class InstrumentationBuilder {
    private final ListBuilder<Target> targets = ListBuilder.builder();
    protected final ElementMatcher.Junction<ByteCodeElement> notDeclaredByObject = ElementMatchers.not(ElementMatchers.isDeclaredBy(Object.class));
    protected final ElementMatcher.Junction<MethodDescription> notTakesArguments = ElementMatchers.not(this.takesArguments(0));
    private static Function0<ElementMatcher.Junction<TypeDescription>> defaultTypeMatcher = Function0.of(() -> ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.not(ElementMatchers.isSynthetic()))).memoized();

    public List<TypeTransformation> collectTransformations(KanelaConfiguration.ModuleConfiguration moduleConfiguration, Instrumentation instrumentation) {
        return this.targets.build().map(t -> this.buildTransformations(((Target)t).instrumentationDescription(), moduleConfiguration, instrumentation)).toJavaList();
    }

    private TypeTransformation buildTransformations(InstrumentationDescription instrumentationDescription, KanelaConfiguration.ModuleConfiguration moduleConfiguration, Instrumentation instrumentation) {
        List<BridgeDescription> bridges = instrumentationDescription.getBridges();
        List<MixinDescription> mixins = instrumentationDescription.getMixins();
        List<AdvisorDescription> advisors = instrumentationDescription.getAdvisors();
        List<AgentBuilder.Transformer> transformers = instrumentationDescription.getTransformers();
        if (moduleConfiguration.shouldValidateMinimumClassFileVersion()) {
            transformers.add(ClassFileVersionValidatorTransformer.Instance);
        }
        if (moduleConfiguration.shouldInjectInBootstrap()) {
            kanela.agent.libs.io.vavr.collection.List<String> helperClassNames = moduleConfiguration.getBootstrapInjectionConfig().getHelperClassNames();
            BootstrapInjector.inject(moduleConfiguration.getTempDir(), instrumentation, helperClassNames.toJavaList());
        }
        return TypeTransformation.of(this.getClass().getName(), instrumentationDescription.getElementMatcher(), instrumentationDescription.getClassLoaderRefiner(), this.collect(bridges, BridgeDescription::makeTransformer), this.collect(mixins, MixinDescription::makeTransformer), this.collect(advisors, advisorDescription -> advisorDescription.makeTransformer(moduleConfiguration)), this.collect(transformers, Function.identity()));
    }

    private <T> List<AgentBuilder.Transformer> collect(List<T> transformerList, Function<T, AgentBuilder.Transformer> f) {
        return transformerList.stream().map(f).collect(Collectors.toList());
    }

    public Target onType(String typeName) {
        InstrumentationDescription.Builder builder = new InstrumentationDescription.Builder();
        Target target = new Target(builder);
        builder.addElementMatcher(() -> ElementMatchers.failSafe(ElementMatchers.named(typeName)));
        this.targets.add(target);
        return target;
    }

    public Target onTypes(String ... typeName) {
        InstrumentationDescription.Builder builder = new InstrumentationDescription.Builder();
        Target target = new Target(builder);
        builder.addElementMatcher(() -> ElementMatchers.failSafe(this.anyTypes(typeName)));
        this.targets.add(target);
        return target;
    }

    public Target onSubTypesOf(String ... typeName) {
        InstrumentationDescription.Builder builder = new InstrumentationDescription.Builder();
        Target target = new Target(builder);
        builder.addElementMatcher(() -> defaultTypeMatcher.apply().and(ElementMatchers.failSafe(ElementMatchers.hasSuperType(this.anyTypes(typeName)))));
        this.targets.add(target);
        return target;
    }

    public Target onTypesAnnotatedWith(String annotationName) {
        InstrumentationDescription.Builder builder = new InstrumentationDescription.Builder();
        Target target = new Target(builder);
        builder.addElementMatcher(() -> defaultTypeMatcher.apply().and(ElementMatchers.failSafe(ElementMatchers.isAnnotatedWith(ElementMatchers.named(annotationName)))));
        this.targets.add(target);
        return target;
    }

    public Target onTypesWithMethodsAnnotatedWith(String annotationName) {
        InstrumentationDescription.Builder builder = new InstrumentationDescription.Builder();
        Target target = new Target(builder);
        ElementMatcher.Junction methodMatcher = ElementMatchers.isAnnotatedWith(ElementMatchers.named(annotationName));
        builder.addElementMatcher(() -> defaultTypeMatcher.apply().and(ElementMatchers.failSafe(ElementMatchers.hasSuperType(ElementMatchers.declaresMethod(methodMatcher)))));
        this.targets.add(target);
        return target;
    }

    public Target onTypesMatching(ElementMatcher<? super TypeDescription> typeMatcher) {
        InstrumentationDescription.Builder builder = new InstrumentationDescription.Builder();
        Target target = new Target(builder);
        builder.addElementMatcher(() -> defaultTypeMatcher.apply().and(ElementMatchers.failSafe(typeMatcher)));
        this.targets.add(target);
        return target;
    }

    public ElementMatcher.Junction<MethodDescription> method(String name) {
        return ElementMatchers.named(name);
    }

    public ElementMatcher.Junction<MethodDescription> isConstructor() {
        return ElementMatchers.isConstructor();
    }

    public ElementMatcher.Junction<MethodDescription> isAbstract() {
        return ElementMatchers.isAbstract();
    }

    public ElementMatcher.Junction<? super TypeDescription> anyTypes(String ... names) {
        return kanela.agent.libs.io.vavr.collection.List.of(names).map(ElementMatchers::named).reduce(ElementMatcher.Junction::or);
    }

    public ElementMatcher.Junction<MethodDescription> takesArguments(Integer quantity) {
        return ElementMatchers.takesArguments(quantity);
    }

    public ElementMatcher.Junction<MethodDescription> takesOneArgumentOf(String type) {
        return ElementMatchers.takesArgument(0, ElementMatchers.named(type));
    }

    public ElementMatcher.Junction<MethodDescription> withArgument(Integer index, Class<?> type) {
        return ElementMatchers.takesArgument((int)index, type);
    }

    public ElementMatcher.Junction<MethodDescription> withArgument(Class<?> type) {
        return this.withArgument(0, type);
    }

    public ElementMatcher.Junction<MethodDescription> anyMethods(String ... names) {
        return kanela.agent.libs.io.vavr.collection.List.of(names).map(this::method).reduce(ElementMatcher.Junction::or);
    }

    public ElementMatcher.Junction<MethodDescription> withReturnTypes(Class<?> ... types) {
        return kanela.agent.libs.io.vavr.collection.List.of(types).map(ElementMatchers::returns).reduce(ElementMatcher.Junction::or);
    }

    public ElementMatcher.Junction<MethodDescription> methodAnnotatedWith(String annotation) {
        return ElementMatchers.isAnnotatedWith(ElementMatchers.named(annotation));
    }

    public ElementMatcher.Junction<MethodDescription> methodAnnotatedWith(Class<? extends Annotation> annotation) {
        return ElementMatchers.isAnnotatedWith(annotation);
    }

    public boolean isEnabled(KanelaConfiguration.ModuleConfiguration moduleConfiguration) {
        return moduleConfiguration.isEnabled();
    }

    public int order() {
        return 1;
    }

    public ClassRefiner.Builder classIsPresent(String className) {
        return ClassRefiner.builder().mustContain(className);
    }

    public static class Target {
        private final InstrumentationDescription.Builder builder;

        Target(InstrumentationDescription.Builder builder) {
            this.builder = builder;
        }

        public Target mixin(Class<?> implementation) {
            this.builder.withMixin(() -> implementation);
            return this;
        }

        public Target bridge(Class<?> implementation) {
            this.builder.withBridge(() -> implementation);
            return this;
        }

        public Target advise(ElementMatcher.Junction<MethodDescription> method, Class<?> implementation) {
            this.builder.withAdvisorFor(method, () -> implementation);
            return this;
        }

        public Target advise(ElementMatcher.Junction<MethodDescription> method, String implementation) {
            this.builder.withAdvisorFor(method, implementation);
            return this;
        }

        public Target intercept(ElementMatcher.Junction<MethodDescription> method, Class<?> implementation) {
            this.builder.withInterceptorFor(method, () -> implementation);
            return this;
        }

        public Target intercept(ElementMatcher.Junction<MethodDescription> method, Object implementation) {
            this.builder.withInterceptorFor(method, implementation);
            return this;
        }

        public Target when(ClassRefiner.Builder ... refinerBuilders) {
            ClassRefiner[] refiners = (ClassRefiner[])kanela.agent.libs.io.vavr.collection.List.of(refinerBuilders).map(ClassRefiner.Builder::build).toJavaArray(ClassRefiner[]::new);
            this.builder.withClassLoaderRefiner(() -> ClassLoaderRefiner.from(refiners));
            return this;
        }

        public Target when(ClassRefiner ... refiners) {
            this.builder.withClassLoaderRefiner(() -> ClassLoaderRefiner.from(refiners));
            return this;
        }

        private InstrumentationDescription instrumentationDescription() {
            return this.builder.build();
        }
    }
}

