/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.uri;

import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.ListIntAcceptor;
import io.jstuff.pipeline.StringAcceptor;
import io.jstuff.pipeline.codec.ErrorHandlingIntPipeline;
import io.jstuff.pipeline.codec.ErrorStrategy;
import java.util.List;

public class URIDecoder<R>
extends ErrorHandlingIntPipeline<R> {
    private State state = State.NORMAL;
    private int character;

    public URIDecoder(IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        super(downstream, errorStrategy);
    }

    public URIDecoder(IntAcceptor<? extends R> downstream) {
        this(downstream, ErrorStrategy.DEFAULT);
    }

    @Override
    public void acceptInt(int value) {
        switch (this.state) {
            case NORMAL: {
                if (value == 37) {
                    this.state = State.FIRST;
                    break;
                }
                if (value == 43) {
                    this.emit(32);
                    break;
                }
                this.emit(value);
                break;
            }
            case FIRST: {
                this.character = this.fromHex(value) << 4;
                this.state = State.SECOND;
                break;
            }
            case SECOND: {
                this.emit(this.character | this.fromHex(value));
                this.state = State.NORMAL;
            }
        }
    }

    private int fromHex(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 65 && ch <= 90) {
            return ch - 65 + 10;
        }
        if (ch >= 97 && ch <= 122) {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("Illegal hex character - " + (char)ch);
    }

    public static String convert(String input) {
        URIDecoder<String> pipe = new URIDecoder<String>(new StringAcceptor());
        pipe.accept(input);
        pipe.safeClose();
        return (String)pipe.getResult();
    }

    public static List<Integer> convert(List<Integer> input) {
        URIDecoder<List<Integer>> pipe = new URIDecoder<List<Integer>>(new ListIntAcceptor());
        pipe.accept(input);
        pipe.safeClose();
        return (List)pipe.getResult();
    }

    static enum State {
        NORMAL,
        FIRST,
        SECOND;

    }
}

