/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.uri;

import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.ListIntAcceptor;
import io.jstuff.pipeline.StringAcceptor;
import io.jstuff.pipeline.codec.EncoderBase;
import io.jstuff.pipeline.uri.URIEncoder;
import io.jstuff.util.IntOutput;
import java.util.List;

public class SchemaURIEncoder<R>
extends EncoderBase<R> {
    private final boolean encodeSpaceAsPlus;

    public SchemaURIEncoder(IntAcceptor<? extends R> downstream, boolean encodeSpaceAsPlus) {
        super(downstream);
        this.encodeSpaceAsPlus = encodeSpaceAsPlus;
    }

    public SchemaURIEncoder(IntAcceptor<? extends R> downstream) {
        this(downstream, false);
    }

    @Override
    public void acceptInt(int value) {
        if (value == 32 && this.encodeSpaceAsPlus) {
            this.emit(43);
        } else if (!URIEncoder.isUnreservedURI(value) && value != 36) {
            this.emit(37);
            IntOutput.output2Hex((int)value, this::emit);
        } else {
            this.emit(value);
        }
    }

    public static String convert(String input) {
        SchemaURIEncoder<String> pipe = new SchemaURIEncoder<String>(new StringAcceptor());
        pipe.accept(input);
        pipe.safeClose();
        return (String)pipe.getResult();
    }

    public static List<Integer> convert(List<Integer> input) {
        SchemaURIEncoder<List<Integer>> pipe = new SchemaURIEncoder<List<Integer>>(new ListIntAcceptor());
        pipe.accept(input);
        pipe.safeClose();
        return (List)pipe.getResult();
    }
}

