/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.codec;

import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.ListIntAcceptor;
import io.jstuff.pipeline.codec.ErrorHandlingIntPipeline;
import io.jstuff.pipeline.codec.ErrorStrategy;
import java.util.List;
import java.util.function.IntConsumer;

public class UTF16_CodePoint<R>
extends ErrorHandlingIntPipeline<R> {
    private IntConsumer state;
    private int highSurrogate;
    private final IntConsumer surrogate = this::terminal;
    private final IntConsumer normal;

    public UTF16_CodePoint(IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        super(downstream, errorStrategy);
        this.state = this.normal = i -> {
            if (Character.isHighSurrogate((char)i)) {
                this.highSurrogate = i;
                this.state = this.surrogate;
            } else {
                this.emit(i);
            }
        };
    }

    public UTF16_CodePoint(IntAcceptor<? extends R> downstream) {
        super(downstream, ErrorStrategy.THROW_EXCEPTION);
        this.state = this.normal = i -> {
            if (Character.isHighSurrogate((char)i)) {
                this.highSurrogate = i;
                this.state = this.surrogate;
            } else {
                this.emit(i);
            }
        };
    }

    @Override
    public void acceptInt(int value) {
        this.state.accept(value);
    }

    @Override
    public boolean isStageComplete() {
        return this.state == this.normal;
    }

    private void terminal(int i) {
        if (!Character.isLowSurrogate((char)i)) {
            this.handleError(i);
        }
        this.emit(Character.toCodePoint((char)this.highSurrogate, (char)i));
        this.state = this.normal;
    }

    public static List<Integer> convert(String input, ErrorStrategy errorStrategy) {
        UTF16_CodePoint<List<Integer>> pipe = new UTF16_CodePoint<List<Integer>>(new ListIntAcceptor(), errorStrategy);
        pipe.accept(input);
        pipe.safeClose();
        return (List)pipe.getResult();
    }

    public static List<Integer> convert(String input) {
        return UTF16_CodePoint.convert(input, ErrorStrategy.THROW_EXCEPTION);
    }
}

