/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.codec;

import io.jstuff.pipeline.ByteArrayAcceptor;
import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.codec.ErrorHandlingIntPipeline;
import io.jstuff.pipeline.codec.ErrorStrategy;

public class UTF16_ASCII<R>
extends ErrorHandlingIntPipeline<R> {
    public UTF16_ASCII(IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        super(downstream, errorStrategy);
    }

    public UTF16_ASCII(IntAcceptor<? extends R> downstream) {
        super(downstream, ErrorStrategy.THROW_EXCEPTION);
    }

    @Override
    public void acceptInt(int value) {
        if (value < 0 || value > 127) {
            throw new IllegalArgumentException("Illegal character");
        }
        this.emit(value);
    }

    public static byte[] convert(String input, ErrorStrategy errorStrategy) {
        UTF16_ASCII<byte[]> pipe = new UTF16_ASCII<byte[]>(new ByteArrayAcceptor(), errorStrategy);
        pipe.accept(input);
        pipe.safeClose();
        return (byte[])pipe.getResult();
    }

    public static byte[] convert(String input) {
        return UTF16_ASCII.convert(input, ErrorStrategy.THROW_EXCEPTION);
    }
}

