/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.codec;

import io.jstuff.pipeline.AbstractIntPipeline;
import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.codec.DecoderFactory;
import java.nio.charset.Charset;

public class SwitchableDecoder<R>
extends AbstractIntPipeline<R> {
    protected IntAcceptor<? extends R> delegate = null;

    public SwitchableDecoder(IntAcceptor<? extends R> downstream) {
        super(downstream);
    }

    @Override
    public void acceptInt(int value) {
        if (this.delegate != null) {
            this.delegate.accept(value);
        } else {
            this.emit(value);
        }
    }

    @Override
    public boolean isStageComplete() {
        return this.delegate == null || this.delegate.isComplete();
    }

    public void switchTo(IntAcceptor<? extends R> delegate) {
        this.delegate = delegate;
    }

    public void switchTo(Charset charset) {
        this.switchTo(DecoderFactory.getDecoder(charset, this.getDownstream()));
    }

    public void switchTo(String charsetName) {
        this.switchTo(DecoderFactory.getDecoder(charsetName, this.getDownstream()));
    }
}

