/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.codec;

import io.jstuff.pipeline.AbstractIntPipeline;
import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.codec.EncoderException;
import io.jstuff.pipeline.codec.ErrorStrategy;

public abstract class ErrorHandlingIntPipeline<R>
extends AbstractIntPipeline<R> {
    private final ErrorStrategy errorStrategy;

    protected ErrorHandlingIntPipeline(IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        super(downstream);
        this.errorStrategy = errorStrategy;
    }

    protected void handleError(int value) {
        if (this.errorStrategy instanceof ErrorStrategy.ThrowException) {
            throw new EncoderException(value);
        }
        if (this.errorStrategy instanceof ErrorStrategy.Substitute) {
            this.emit(((ErrorStrategy.Substitute)this.errorStrategy).getSubstitute());
        }
    }
}

