/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.codec;

import io.jstuff.pipeline.AbstractIntPipeline;
import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.codec.CodePoint_UTF8;
import io.jstuff.pipeline.codec.ErrorStrategy;
import io.jstuff.pipeline.codec.UTF16_ASCII;
import io.jstuff.pipeline.codec.UTF16_ISO8859_1;
import io.jstuff.pipeline.codec.UTF16_ISO8859_15;
import io.jstuff.pipeline.codec.UTF16_Windows1252;
import java.nio.charset.Charset;

public class EncoderFactory {
    public static <R> AbstractIntPipeline<R> getEncoder(String charsetName, IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        if (charsetName.equalsIgnoreCase("windows-1252")) {
            return new UTF16_Windows1252<R>(downstream, errorStrategy);
        }
        if (charsetName.equalsIgnoreCase("ISO-8859-1")) {
            return new UTF16_ISO8859_1<R>(downstream, errorStrategy);
        }
        if (charsetName.equalsIgnoreCase("ISO-8859-15")) {
            return new UTF16_ISO8859_15<R>(downstream, errorStrategy);
        }
        if (charsetName.equalsIgnoreCase("US-ASCII")) {
            return new UTF16_ASCII<R>(downstream, errorStrategy);
        }
        return new CodePoint_UTF8<R>(downstream, errorStrategy);
    }

    public static <R> AbstractIntPipeline<R> getEncoder(String charsetName, IntAcceptor<? extends R> downstream) {
        return EncoderFactory.getEncoder(charsetName, downstream, ErrorStrategy.DEFAULT);
    }

    public static <R> AbstractIntPipeline<R> getEncoder(Charset charset, IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        return EncoderFactory.getEncoder(charset.name(), downstream, errorStrategy);
    }

    public static <R> AbstractIntPipeline<R> getEncoder(Charset charset, IntAcceptor<? extends R> downstream) {
        return EncoderFactory.getEncoder(charset.name(), downstream, ErrorStrategy.DEFAULT);
    }
}

