/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.codec;

import io.jstuff.pipeline.ByteArrayAcceptor;
import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.codec.ErrorHandlingIntPipeline;
import io.jstuff.pipeline.codec.ErrorStrategy;
import java.util.List;

public class CodePoint_UTF8<R>
extends ErrorHandlingIntPipeline<R> {
    public CodePoint_UTF8(IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        super(downstream, errorStrategy);
    }

    public CodePoint_UTF8(IntAcceptor<? extends R> downstream) {
        super(downstream, ErrorStrategy.THROW_EXCEPTION);
    }

    @Override
    public void acceptInt(int value) {
        if (value <= 127) {
            this.emit(value);
        } else if (value <= 2047) {
            this.emit(0xC0 | value >> 6);
            this.emit(0x80 | value & 0x3F);
        } else if (value <= 65535) {
            this.emit(0xE0 | value >> 12);
            this.emit(0x80 | value >> 6 & 0x3F);
            this.emit(0x80 | value & 0x3F);
        } else if (value <= 0x10FFFF) {
            this.emit(0xF0 | value >> 18);
            this.emit(0x80 | value >> 12 & 0x3F);
            this.emit(0x80 | value >> 6 & 0x3F);
            this.emit(0x80 | value & 0x3F);
        } else {
            this.handleError(value);
        }
    }

    public static byte[] convert(List<Integer> input, ErrorStrategy errorStrategy) {
        CodePoint_UTF8<byte[]> pipe = new CodePoint_UTF8<byte[]>(new ByteArrayAcceptor(), errorStrategy);
        pipe.accept(input);
        pipe.safeClose();
        return (byte[])pipe.getResult();
    }

    public static byte[] convert(List<Integer> input) {
        return CodePoint_UTF8.convert(input, ErrorStrategy.THROW_EXCEPTION);
    }
}

