/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.base64;

import io.jstuff.pipeline.ByteArrayAcceptor;
import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.ListIntAcceptor;
import io.jstuff.pipeline.StringAcceptor;
import io.jstuff.pipeline.codec.ErrorHandlingIntPipeline;
import io.jstuff.pipeline.codec.ErrorStrategy;
import java.util.List;

public class Base64Decoder<R>
extends ErrorHandlingIntPipeline<R> {
    public static final int INVALID_MARKER = 127;
    public static final int EQUALS_SIGN_MARKER = 126;
    public static final int WHITESPACE_MARKER = 125;
    public static final int MAX_DECODED_VALUE = 63;
    public static final byte[] decodingArray;
    private State state = State.FIRST;
    private int saved;

    public Base64Decoder(IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        super(downstream, errorStrategy);
    }

    public Base64Decoder(IntAcceptor<? extends R> downstream) {
        this(downstream, ErrorStrategy.DEFAULT);
    }

    @Override
    public void acceptInt(int value) {
        if ((value & 0xFFFFFF80) != 0) {
            this.handleError(value);
            return;
        }
        int decoded = decodingArray[value];
        if (decoded == 127) {
            this.handleError(value);
            return;
        }
        switch (this.state) {
            case FIRST: {
                if (decoded == 125) break;
                if (decoded == 126) {
                    this.handleError(value);
                    break;
                }
                this.saved = decoded;
                this.state = State.SECOND;
                break;
            }
            case SECOND: {
                if (decoded > 63) {
                    this.handleError(value);
                    this.state = State.FIRST;
                    break;
                }
                this.emit(this.saved << 2 & 0xFC | decoded >> 4 & 3);
                this.saved = decoded;
                this.state = State.THIRD;
                break;
            }
            case THIRD: {
                if (decoded > 63) {
                    if (decoded == 126 && (this.saved & 0xF) == 0) {
                        this.state = State.EQUALS_EXPECTED;
                        break;
                    }
                    this.handleError(value);
                    this.state = State.FIRST;
                    break;
                }
                this.emit(this.saved << 4 & 0xF0 | decoded >> 2 & 0xF);
                this.saved = decoded;
                this.state = State.FOURTH;
                break;
            }
            case FOURTH: {
                if (decoded > 63) {
                    if (decoded == 126 && (this.saved & 3) == 0) {
                        this.state = State.COMPLETE;
                        break;
                    }
                    this.handleError(value);
                    this.state = State.FIRST;
                    break;
                }
                this.emit(this.saved << 6 & 0xC0 | decoded);
                this.state = State.FIRST;
                break;
            }
            case EQUALS_EXPECTED: {
                if (decoded != 126) {
                    this.handleError(value);
                }
                this.state = State.COMPLETE;
                break;
            }
            case COMPLETE: {
                if (decoded == 125) break;
                this.handleError(value);
            }
        }
    }

    @Override
    public boolean isStageComplete() {
        return this.state == State.FIRST || this.state == State.COMPLETE || this.state == State.THIRD && (this.saved & 0xF) == 0 || this.state == State.FOURTH && (this.saved & 3) == 0;
    }

    public static byte[] convert(byte[] input, ErrorStrategy errorStrategy) {
        Base64Decoder<byte[]> pipe = new Base64Decoder<byte[]>(new ByteArrayAcceptor(), errorStrategy);
        pipe.accept(input);
        pipe.safeClose();
        return (byte[])pipe.getResult();
    }

    public static byte[] convert(byte[] input) {
        return Base64Decoder.convert(input, ErrorStrategy.THROW_EXCEPTION);
    }

    public static String convert(String input, ErrorStrategy errorStrategy) {
        Base64Decoder<String> pipe = new Base64Decoder<String>(new StringAcceptor(), errorStrategy);
        pipe.accept(input);
        pipe.safeClose();
        return (String)pipe.getResult();
    }

    public static String convert(String input) {
        return Base64Decoder.convert(input, ErrorStrategy.THROW_EXCEPTION);
    }

    public static List<Integer> convert(List<Integer> input, ErrorStrategy errorStrategy) {
        Base64Decoder<List<Integer>> pipe = new Base64Decoder<List<Integer>>(new ListIntAcceptor(), errorStrategy);
        pipe.accept(input);
        pipe.safeClose();
        return (List)pipe.getResult();
    }

    public static List<Integer> convert(List<Integer> input) {
        return Base64Decoder.convert(input, ErrorStrategy.THROW_EXCEPTION);
    }

    static {
        int i;
        decodingArray = new byte[128];
        for (i = 0; i < 128; ++i) {
            Base64Decoder.decodingArray[i] = 127;
        }
        for (i = 0; i < 26; ++i) {
            Base64Decoder.decodingArray[65 + i] = (byte)i;
        }
        for (i = 0; i < 26; ++i) {
            Base64Decoder.decodingArray[97 + i] = (byte)(i + 26);
        }
        for (i = 0; i < 10; ++i) {
            Base64Decoder.decodingArray[48 + i] = (byte)(i + 52);
        }
        Base64Decoder.decodingArray[43] = 62;
        Base64Decoder.decodingArray[45] = 62;
        Base64Decoder.decodingArray[47] = 63;
        Base64Decoder.decodingArray[95] = 63;
        Base64Decoder.decodingArray[44] = 63;
        Base64Decoder.decodingArray[61] = 126;
        Base64Decoder.decodingArray[32] = 125;
        Base64Decoder.decodingArray[10] = 125;
        Base64Decoder.decodingArray[13] = 125;
        Base64Decoder.decodingArray[9] = 125;
    }

    public static enum State {
        FIRST,
        SECOND,
        THIRD,
        FOURTH,
        EQUALS_EXPECTED,
        COMPLETE;

    }
}

