/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.uri;

import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.codec.EncoderBase;
import io.jstuff.pipeline.uri.URIEncoder;
import io.jstuff.util.IntOutput;

public class SchemaURIEncoder<R>
extends EncoderBase<R> {
    private final boolean encodeSpaceAsPlus;

    public SchemaURIEncoder(IntAcceptor<? extends R> downstream, boolean encodeSpaceAsPlus) {
        super(downstream);
        this.encodeSpaceAsPlus = encodeSpaceAsPlus;
    }

    public SchemaURIEncoder(IntAcceptor<? extends R> downstream) {
        this(downstream, false);
    }

    @Override
    public void acceptInt(int value) {
        if (value == 32 && this.encodeSpaceAsPlus) {
            this.emit(43);
        } else if (!URIEncoder.isUnreservedURI(value) && value != 36) {
            this.emit(37);
            IntOutput.output2Hex((int)value, this::emit);
        } else {
            this.emit(value);
        }
    }
}

