/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.codec;

import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.codec.CodePoint_UTF16;
import io.jstuff.pipeline.codec.DecoderFactory;
import io.jstuff.pipeline.codec.SwitchableDecoder;
import io.jstuff.pipeline.codec.UTF16BE_UTF16;
import io.jstuff.pipeline.codec.UTF16LE_UTF16;
import io.jstuff.pipeline.codec.UTF32BE_CodePoint;
import io.jstuff.pipeline.codec.UTF32LE_CodePoint;
import io.jstuff.pipeline.codec.UTF8_UTF16;
import io.jstuff.pipeline.codec.Windows1252_UTF16;
import java.nio.charset.Charset;

public class DynamicDecoder<R>
extends SwitchableDecoder<R> {
    protected State state;
    private final int[] buffer = new int[4];
    private int index = 0;

    public DynamicDecoder(IntAcceptor<? extends R> downstream) {
        this(downstream, null);
    }

    public DynamicDecoder(IntAcceptor<? extends R> downstream, Charset charset) {
        super(downstream);
        if (charset == null) {
            this.state = State.INITIAL;
        } else {
            this.delegate = DecoderFactory.getDecoder(charset, downstream);
            this.state = State.DELEGATED;
        }
    }

    @Override
    public void acceptInt(int value) {
        block0 : switch (this.state) {
            case INITIAL: {
                this.buffer[this.index++] = value;
                switch (value) {
                    case 0: {
                        this.state = State.FIRST_00;
                        break block0;
                    }
                    case 255: {
                        this.state = State.FIRST_FF;
                        break block0;
                    }
                    case 254: {
                        this.state = State.FIRST_FE;
                        break block0;
                    }
                    case 239: {
                        this.state = State.FIRST_EF;
                        break block0;
                    }
                }
                this.state = State.FIRST_ANY;
                break;
            }
            case FIRST_00: {
                this.buffer[this.index++] = value;
                if (value == 0) {
                    this.state = State.FIRST_TWO_00_00;
                    break;
                }
                this.switchTo(new UTF16BE_UTF16(this.getDownstream()));
                break;
            }
            case FIRST_TWO_00_00: {
                if (value == 254) {
                    this.state = State.FIRST_THREE_00_00_FE;
                    break;
                }
                this.switchTo(new UTF32BE_CodePoint(new CodePoint_UTF16(this.getDownstream())));
                this.delegate.accept(value);
                break;
            }
            case FIRST_THREE_00_00_FE: {
                if (value == 255) {
                    this.switchTo(new UTF32BE_CodePoint(new CodePoint_UTF16(this.getDownstream())));
                    this.delegate.accept(254);
                    this.delegate.accept(value);
                    break;
                }
                this.index = 0;
                this.switchTo(new UTF32BE_CodePoint(new CodePoint_UTF16(this.getDownstream())));
                break;
            }
            case FIRST_FF: {
                if (value == 254) {
                    this.buffer[this.index++] = value;
                    this.state = State.FIRST_TWO_FF_FE;
                    break;
                }
                this.delegateToWindows1252(value);
                break;
            }
            case FIRST_TWO_FF_FE: {
                if (value == 0) {
                    this.buffer[this.index++] = 0;
                    this.state = State.FIRST_THREE_FF_FE_00;
                    break;
                }
                this.index = 0;
                this.switchTo(new UTF16LE_UTF16(this.getDownstream()));
                this.delegate.accept(value);
                break;
            }
            case FIRST_THREE_FF_FE_00: {
                if (value == 0) {
                    this.index = 0;
                    this.switchTo(new UTF32LE_CodePoint(new CodePoint_UTF16(this.getDownstream())));
                } else {
                    this.index = 0;
                    this.switchTo(new UTF16LE_UTF16(this.getDownstream()));
                    this.delegate.accept(this.buffer[2]);
                    this.delegate.accept(value);
                }
                this.index = 0;
                break;
            }
            case FIRST_FE: {
                if (value == 255) {
                    this.index = 0;
                    this.switchTo(new UTF16BE_UTF16(this.getDownstream()));
                    break;
                }
                this.delegateToWindows1252(value);
                break;
            }
            case FIRST_EF: {
                if (value == 187) {
                    this.buffer[this.index++] = value;
                    this.state = State.FIRST_TWO_EF_BB;
                    break;
                }
                if ((value & 0xC0) == 128) {
                    this.delegateToUTF8(value);
                    break;
                }
                this.delegateToWindows1252(value);
                break;
            }
            case FIRST_TWO_EF_BB: {
                if (value == 191) {
                    this.index = 0;
                    this.switchTo(new UTF8_UTF16(this.getDownstream()));
                    break;
                }
                if ((value & 0xC0) == 128) {
                    this.delegateToUTF8(value);
                    break;
                }
                this.delegateToWindows1252(value);
                break;
            }
            case FIRST_ANY: {
                if (value == 0) {
                    this.buffer[this.index++] = value;
                    this.state = State.FIRST_TWO_ANY_00;
                    break;
                }
                int first = this.buffer[0];
                if (first >= 128) {
                    if ((first & 0xE0) == 192) {
                        if ((value & 0xC0) == 128) {
                            this.delegateToUTF8(value);
                            break;
                        }
                        this.delegateToWindows1252(value);
                        break;
                    }
                    if (first >= 224 && first <= 247) {
                        if ((value & 0xC0) == 128) {
                            this.buffer[this.index++] = value;
                            this.state = State.POSSIBLE_UTF8_3BYTE;
                            break;
                        }
                        this.delegateToWindows1252(value);
                        break;
                    }
                    this.delegateToWindows1252(value);
                    break;
                }
                this.emit(first);
                this.index = 0;
                if (value >= 128) {
                    if (value >= 192 && value <= 247) {
                        this.buffer[this.index++] = value;
                        this.state = State.POSSIBLE_UTF8;
                        break;
                    }
                    this.delegateToWindows1252(value);
                    break;
                }
                this.emit(value);
                this.state = State.UNDETERMINED;
                break;
            }
            case FIRST_TWO_ANY_00: {
                if (value == 0) {
                    this.buffer[this.index++] = 0;
                    this.state = State.FIRST_THREE_ANY_00_00;
                    break;
                }
                this.switchTo(new UTF16LE_UTF16(this.getDownstream()));
                this.delegate.accept(value);
                break;
            }
            case FIRST_THREE_ANY_00_00: {
                this.switchTo(value == 0 ? new UTF32LE_CodePoint(new CodePoint_UTF16(this.getDownstream())) : new UTF16LE_UTF16(this.getDownstream()));
                this.delegate.accept(value);
                break;
            }
            case UNDETERMINED: {
                if (value >= 128) {
                    if (value >= 192 && value <= 247) {
                        this.buffer[this.index++] = value;
                        this.state = State.POSSIBLE_UTF8;
                        break;
                    }
                    this.delegateToWindows1252(value);
                    break;
                }
                this.emit(value);
                break;
            }
            case POSSIBLE_UTF8: {
                if ((value & 0xC0) == 128) {
                    if ((this.buffer[0] & 0x20) == 0) {
                        this.delegateToUTF8(value);
                        break;
                    }
                    this.buffer[this.index++] = value;
                    this.state = State.POSSIBLE_UTF8_3BYTE;
                    break;
                }
                this.delegateToWindows1252(value);
                break;
            }
            case POSSIBLE_UTF8_3BYTE: {
                if ((value & 0xC0) == 128) {
                    if ((this.buffer[0] & 0x10) == 0) {
                        this.delegateToUTF8(value);
                        break;
                    }
                    this.buffer[this.index++] = value;
                    this.state = State.POSSIBLE_UTF8_4BYTE;
                    break;
                }
                this.delegateToWindows1252(value);
                break;
            }
            case POSSIBLE_UTF8_4BYTE: {
                if ((value & 0xC0) == 128) {
                    this.delegateToUTF8(value);
                    break;
                }
                this.delegateToWindows1252(value);
                break;
            }
            case DELEGATED: {
                this.delegate.accept(value);
            }
        }
    }

    @Override
    public void close() {
        switch (this.state) {
            case INITIAL: 
            case FIRST_TWO_FF_FE: 
            case UNDETERMINED: {
                break;
            }
            case FIRST_00: 
            case FIRST_TWO_00_00: 
            case FIRST_THREE_00_00_FE: 
            case FIRST_THREE_FF_FE_00: 
            case FIRST_TWO_ANY_00: 
            case FIRST_THREE_ANY_00_00: {
                break;
            }
            case FIRST_FF: 
            case FIRST_FE: 
            case FIRST_EF: 
            case FIRST_TWO_EF_BB: 
            case FIRST_ANY: 
            case POSSIBLE_UTF8: 
            case POSSIBLE_UTF8_3BYTE: 
            case POSSIBLE_UTF8_4BYTE: {
                this.switchTo(new Windows1252_UTF16(this.getDownstream()));
                break;
            }
            case DELEGATED: {
                this.delegate.safeClose();
            }
        }
        this.getDownstream().safeClose();
    }

    @Override
    public boolean isStageComplete() {
        switch (this.state) {
            case INITIAL: 
            case UNDETERMINED: {
                return true;
            }
            case DELEGATED: {
                return this.delegate.isComplete();
            }
        }
        return false;
    }

    @Override
    public void switchTo(IntAcceptor<? extends R> delegate) {
        this.delegate = delegate;
        this.state = State.DELEGATED;
        for (int i = 0; i < this.index; ++i) {
            delegate.accept(this.buffer[i]);
        }
        this.index = 0;
    }

    @Override
    public void switchTo(Charset charset) {
        this.switchTo(DecoderFactory.getDecoder(charset, this.getDownstream()));
    }

    @Override
    public void switchTo(String charsetName) {
        this.switchTo(DecoderFactory.getDecoder(charsetName, this.getDownstream()));
    }

    private void delegateToUTF8(int value) {
        this.switchTo(new UTF8_UTF16(this.getDownstream()));
        this.delegate.accept(value);
    }

    private void delegateToWindows1252(int value) {
        this.switchTo(new Windows1252_UTF16(this.getDownstream()));
        this.delegate.accept(value);
    }

    public static enum State {
        INITIAL,
        FIRST_00,
        FIRST_FF,
        FIRST_FE,
        FIRST_EF,
        FIRST_TWO_EF_BB,
        FIRST_ANY,
        FIRST_TWO_ANY_00,
        FIRST_THREE_ANY_00_00,
        FIRST_TWO_00_00,
        FIRST_THREE_00_00_FE,
        FIRST_TWO_FF_FE,
        FIRST_THREE_FF_FE_00,
        UNDETERMINED,
        POSSIBLE_UTF8,
        POSSIBLE_UTF8_3BYTE,
        POSSIBLE_UTF8_4BYTE,
        DELEGATED;

    }
}

