/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.codec;

import io.jstuff.pipeline.AbstractIntPipeline;
import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.codec.ASCII_UTF16;
import io.jstuff.pipeline.codec.ErrorStrategy;
import io.jstuff.pipeline.codec.ISO8859_15_UTF16;
import io.jstuff.pipeline.codec.ISO8859_1_UTF16;
import io.jstuff.pipeline.codec.UTF8_UTF16;
import io.jstuff.pipeline.codec.Windows1252_UTF16;
import java.nio.charset.Charset;

public class DecoderFactory {
    public static <R> AbstractIntPipeline<R> getDecoder(String charsetName, IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        if (charsetName.equalsIgnoreCase("windows-1252")) {
            return new Windows1252_UTF16<R>(downstream, errorStrategy);
        }
        if (charsetName.equalsIgnoreCase("ISO-8859-1")) {
            return new ISO8859_1_UTF16<R>(downstream, errorStrategy);
        }
        if (charsetName.equalsIgnoreCase("ISO-8859-15")) {
            return new ISO8859_15_UTF16<R>(downstream, errorStrategy);
        }
        if (charsetName.equalsIgnoreCase("US-ASCII")) {
            return new ASCII_UTF16<R>(downstream, errorStrategy);
        }
        return new UTF8_UTF16<R>(downstream, errorStrategy);
    }

    public static <R> AbstractIntPipeline<R> getDecoder(String charsetName, IntAcceptor<? extends R> downstream) {
        return DecoderFactory.getDecoder(charsetName, downstream, ErrorStrategy.THROW_EXCEPTION);
    }

    public static <R> AbstractIntPipeline<R> getDecoder(Charset charset, IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        return DecoderFactory.getDecoder(charset.name(), downstream, errorStrategy);
    }

    public static <R> AbstractIntPipeline<R> getDecoder(Charset charset, IntAcceptor<? extends R> downstream) {
        return DecoderFactory.getDecoder(charset.name(), downstream, ErrorStrategy.THROW_EXCEPTION);
    }
}

