/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline;

import io.jstuff.pipeline.BaseAcceptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.function.IntConsumer;

public interface IntAcceptor<R>
extends BaseAcceptor<R>,
IntConsumer {
    @Override
    public void accept(int var1);

    default public void accept(CharSequence cs) {
        int n = cs.length();
        for (int i = 0; i < n; ++i) {
            this.accept(cs.charAt(i));
        }
    }

    default public void accept(char[] chars, int offset, int length) {
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            this.accept(chars[i]);
        }
    }

    default public void accept(char[] chars) {
        this.accept(chars, 0, chars.length);
    }

    default public void accept(byte[] bytes, int offset, int length) {
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            this.accept(bytes[i] & 0xFF);
        }
    }

    default public void accept(byte[] bytes) {
        this.accept(bytes, 0, bytes.length);
    }

    default public void accept(InputStream inputStream) throws IOException {
        int b;
        while ((b = inputStream.read()) >= 0) {
            this.accept(b & 0xFF);
        }
    }

    default public void accept(Reader reader) throws IOException {
        int ch;
        while ((ch = reader.read()) >= 0) {
            this.accept(ch);
        }
    }

    default public void accept(CharBuffer charBuffer) {
        while (charBuffer.hasRemaining()) {
            this.accept(charBuffer.get());
        }
    }

    default public void accept(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining()) {
            this.accept(byteBuffer.get() & 0xFF);
        }
    }
}

