/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.ACLProxy;
import io.jstuff.log.AbstractLoggerFactory;
import io.jstuff.log.FormattingLoggerFactory;
import io.jstuff.log.GradleProxy;
import io.jstuff.log.JavaLogger;
import io.jstuff.log.Level;
import io.jstuff.log.Logger;
import io.jstuff.log.LoggerProxy;
import io.jstuff.log.ProxyLogger;
import io.jstuff.log.Slf4jProxy;
import java.time.Clock;

public class DynamicLoggerFactory
extends AbstractLoggerFactory<Logger> {
    private static LoggerProxy proxy = null;
    private static boolean javaLogging = false;
    private FormattingLoggerFactory<?, ?> formattingLoggerFactory = null;

    public DynamicLoggerFactory(Level defaultLevel, Clock defaultClock) {
        super(defaultLevel, defaultClock);
    }

    public DynamicLoggerFactory(Level defaultLevel) {
        super(defaultLevel, systemClock);
    }

    public DynamicLoggerFactory(Clock defaultClock) {
        super(systemDefaultLevel, defaultClock);
    }

    public DynamicLoggerFactory() {
        super(systemDefaultLevel, systemClock);
    }

    @Override
    protected Logger createLogger(String name, Level level, Clock clock) {
        if (proxy != null) {
            try {
                return new ProxyLogger(name, level, clock, proxy);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (javaLogging) {
            return new JavaLogger(name, level, clock);
        }
        return this.getFormattingLoggerFactory().getLogger(name, level, clock);
    }

    private synchronized FormattingLoggerFactory<?, ?> getFormattingLoggerFactory() {
        if (this.formattingLoggerFactory == null) {
            this.formattingLoggerFactory = FormattingLoggerFactory.getBasic();
        }
        return this.formattingLoggerFactory;
    }

    static {
        try {
            proxy = new GradleProxy();
        }
        catch (Exception ignore) {
            try {
                proxy = new Slf4jProxy();
            }
            catch (Exception ignore2) {
                try {
                    proxy = new ACLProxy();
                }
                catch (Exception ignore3) {
                    javaLogging = System.getProperty("java.util.logging.config.file") != null || DynamicLoggerFactory.class.getResource("logging.properties") != null;
                }
            }
        }
    }
}

