/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.AbstractFormatter;
import io.jstuff.log.AbstractLogger;
import io.jstuff.log.Level;
import io.jstuff.log.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.util.function.IntConsumer;

public class BasicFormatter
extends AbstractFormatter {
    public static final int defaultNameLengthLimit = 40;
    private int nameLengthLimit = 40;
    private boolean colouredLevel = true;

    @Override
    public void format(Instant time, Logger logger, Level level, Object message, Throwable throwable, IntConsumer outFunction) {
        String messageString;
        int dayMillis = BasicFormatter.getDayMillis(time, logger.getClock().getZone());
        String string = messageString = message != null ? message.toString() : "";
        if (!messageString.isEmpty() || throwable == null) {
            this.outputMessage(dayMillis, logger, level, messageString, outFunction);
        }
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            throwable.printStackTrace(new PrintWriter(sw));
            this.outputMessage(dayMillis, logger, level, sw.toString(), outFunction);
        }
    }

    private void outputMessage(int dayMillis, Logger logger, Level level, String text, IntConsumer outFunction) {
        AbstractLogger.outputMultiLine(text, line -> {
            BasicFormatter.outputTime(dayMillis, outFunction);
            outFunction.accept(32);
            if (this.colouredLevel) {
                BasicFormatter.outputLevel5Coloured(level, outFunction);
            } else {
                BasicFormatter.outputLevel5(level, outFunction);
            }
            outFunction.accept(32);
            if (this.nameLengthLimit > 0) {
                BasicFormatter.outputNameWithLimit(this.nameLengthLimit, logger.getName(), outFunction);
            }
            outFunction.accept(58);
            if (!line.isEmpty()) {
                outFunction.accept(32);
                BasicFormatter.outputText(line, outFunction);
            }
            outFunction.accept(10);
        });
    }

    public int getNameLengthLimit() {
        return this.nameLengthLimit;
    }

    public void setNameLengthLimit(int nameLengthLimit) {
        this.nameLengthLimit = Math.max(nameLengthLimit, 8);
    }

    public boolean isColouredLevel() {
        return this.colouredLevel;
    }

    public void setColouredLevel(boolean colouredLevel) {
        this.colouredLevel = colouredLevel;
    }
}

