/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.ACLProxyException;
import io.jstuff.log.Level;
import io.jstuff.log.LoggerProxy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ACLProxy
implements LoggerProxy {
    private final Object loggerFactory;
    private final Method getLoggerMethod;
    private final Method isTraceEnabledMethod;
    private final Method isDebugEnabledMethod;
    private final Method isInfoEnabledMethod;
    private final Method isWarnEnabledMethod;
    private final Method isErrorEnabledMethod;
    private final Method traceMethod;
    private final Method debugMethod;
    private final Method infoMethod;
    private final Method warnMethod;
    private final Method errorMethod;
    private final Method errorThrowableMethod;
    private final Method[] dynamicIsEnabledMethods;
    private final Method[] dynamicLogMethods;

    public ACLProxy() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> loggerFactoryClass = Class.forName("org.apache.commons.logging.LogFactory");
        Method getFactoryMethod = loggerFactoryClass.getMethod("getFactory", new Class[0]);
        this.loggerFactory = getFactoryMethod.invoke(null, new Object[0]);
        this.getLoggerMethod = loggerFactoryClass.getMethod("getInstance", String.class);
        Class<?> loggerClass = Class.forName("org.apache.commons.logging.Log");
        this.isTraceEnabledMethod = loggerClass.getMethod("isTraceEnabled", new Class[0]);
        this.isDebugEnabledMethod = loggerClass.getMethod("isDebugEnabled", new Class[0]);
        this.isInfoEnabledMethod = loggerClass.getMethod("isInfoEnabled", new Class[0]);
        this.isWarnEnabledMethod = loggerClass.getMethod("isWarnEnabled", new Class[0]);
        this.isErrorEnabledMethod = loggerClass.getMethod("isErrorEnabled", new Class[0]);
        this.traceMethod = loggerClass.getMethod("trace", Object.class);
        this.debugMethod = loggerClass.getMethod("debug", Object.class);
        this.infoMethod = loggerClass.getMethod("info", Object.class);
        this.warnMethod = loggerClass.getMethod("warn", Object.class);
        this.errorMethod = loggerClass.getMethod("error", Object.class);
        this.errorThrowableMethod = loggerClass.getMethod("error", Object.class, Throwable.class);
        this.dynamicIsEnabledMethods = new Method[]{this.isTraceEnabledMethod, this.isDebugEnabledMethod, this.isInfoEnabledMethod, this.isWarnEnabledMethod, this.isErrorEnabledMethod};
        this.dynamicLogMethods = new Method[]{this.traceMethod, this.debugMethod, this.infoMethod, this.warnMethod, this.errorMethod};
    }

    @Override
    public Object getLogger(String name) throws InvocationTargetException, IllegalAccessException {
        return this.getLoggerMethod.invoke(this.loggerFactory, name);
    }

    @Override
    public boolean isTraceEnabled(Object aclLog) {
        try {
            return (Boolean)this.isTraceEnabledMethod.invoke(aclLog, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ACLProxyException(e);
        }
    }

    @Override
    public boolean isDebugEnabled(Object aclLog) {
        try {
            return (Boolean)this.isDebugEnabledMethod.invoke(aclLog, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ACLProxyException(e);
        }
    }

    @Override
    public boolean isInfoEnabled(Object aclLog) {
        try {
            return (Boolean)this.isInfoEnabledMethod.invoke(aclLog, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ACLProxyException(e);
        }
    }

    @Override
    public boolean isWarnEnabled(Object aclLog) {
        try {
            return (Boolean)this.isWarnEnabledMethod.invoke(aclLog, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ACLProxyException(e);
        }
    }

    @Override
    public boolean isErrorEnabled(Object aclLog) {
        try {
            return (Boolean)this.isErrorEnabledMethod.invoke(aclLog, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ACLProxyException(e);
        }
    }

    @Override
    public boolean isEnabled(Object aclLog, Level level) {
        try {
            return (Boolean)this.dynamicIsEnabledMethods[level.ordinal()].invoke(aclLog, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ACLProxyException(e);
        }
    }

    @Override
    public void trace(Object aclLog, String text) {
        try {
            this.traceMethod.invoke(aclLog, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ACLProxyException(e);
        }
    }

    @Override
    public void debug(Object aclLog, String text) {
        try {
            this.debugMethod.invoke(aclLog, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ACLProxyException(e);
        }
    }

    @Override
    public void info(Object aclLog, String text) {
        try {
            this.infoMethod.invoke(aclLog, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ACLProxyException(e);
        }
    }

    @Override
    public void warn(Object aclLog, String text) {
        try {
            this.warnMethod.invoke(aclLog, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ACLProxyException(e);
        }
    }

    @Override
    public void error(Object aclLog, String text) {
        try {
            this.errorMethod.invoke(aclLog, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ACLProxyException(e);
        }
    }

    @Override
    public void error(Object aclLog, String text, Throwable throwable) {
        try {
            this.errorThrowableMethod.invoke(aclLog, text, throwable);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ACLProxyException(e);
        }
    }

    @Override
    public void log(Object aclLog, Level level, String text) {
        try {
            this.dynamicLogMethods[level.ordinal()].invoke(aclLog, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ACLProxyException(e);
        }
    }
}

