/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.AbstractLogger;
import io.jstuff.log.Level;
import io.jstuff.log.LogListener;
import io.jstuff.log.LoggerFactory;
import java.time.Clock;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JavaLogger
extends AbstractLogger {
    private final Logger javaLogger;

    JavaLogger(String name, Level level, Clock clock) {
        super(name, level, clock);
        this.javaLogger = Logger.getLogger(name);
        this.javaLogger.setLevel(JavaLogger.convertLevel(level));
    }

    @Override
    public void setLevel(Level level) {
        super.setLevel(level);
        this.javaLogger.setLevel(JavaLogger.convertLevel(level));
    }

    public boolean isTraceEnabled() {
        return this.javaLogger.isLoggable(java.util.logging.Level.FINER);
    }

    public boolean isDebugEnabled() {
        return this.javaLogger.isLoggable(java.util.logging.Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.javaLogger.isLoggable(java.util.logging.Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.javaLogger.isLoggable(java.util.logging.Level.WARNING);
    }

    public boolean isErrorEnabled() {
        return this.javaLogger.isLoggable(java.util.logging.Level.SEVERE);
    }

    public boolean isEnabled(Level level) {
        return this.javaLogger.isLoggable(JavaLogger.convertLevel(level));
    }

    public void trace(Object message) {
        this.log(Level.TRACE, java.util.logging.Level.FINER, message, null);
    }

    public void debug(Object message) {
        this.log(Level.DEBUG, java.util.logging.Level.FINE, message, null);
    }

    public void info(Object message) {
        this.log(Level.INFO, java.util.logging.Level.INFO, message, null);
    }

    public void warn(Object message) {
        this.log(Level.WARN, java.util.logging.Level.WARNING, message, null);
    }

    public void error(Object message) {
        this.log(Level.ERROR, java.util.logging.Level.SEVERE, message, null);
    }

    public void error(Throwable thrown, Object message) {
        this.log(Level.ERROR, java.util.logging.Level.SEVERE, message, thrown);
    }

    public void log(Level level, Object message) {
        this.log(level, JavaLogger.convertLevel(level), message, null);
    }

    private void log(Level level, java.util.logging.Level julLevel, Object message, Throwable throwable) {
        String text = String.valueOf(message);
        long millis = this.getClock().millis();
        if (LogListener.present()) {
            LogListener.invokeAll(millis, this, level, text, throwable);
        }
        StackTraceElement sourceDetails = LoggerFactory.callerInfo();
        JavaLogger.outputMultiLine(text, s -> this.outputLogRecord(julLevel, (String)s, millis, sourceDetails, throwable));
    }

    private void outputLogRecord(java.util.logging.Level level, String message, long millis, StackTraceElement callerInfo, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, message);
        logRecord.setMillis(millis);
        logRecord.setSourceClassName(callerInfo.getClassName());
        logRecord.setSourceMethodName(callerInfo.getMethodName());
        logRecord.setThrown(throwable);
        this.javaLogger.log(logRecord);
    }

    private static java.util.logging.Level convertLevel(Level level) {
        switch (level) {
            case TRACE: {
                return java.util.logging.Level.FINER;
            }
            case DEBUG: {
                return java.util.logging.Level.FINE;
            }
            case INFO: {
                return java.util.logging.Level.INFO;
            }
            case WARN: {
                return java.util.logging.Level.WARNING;
            }
        }
        return java.util.logging.Level.SEVERE;
    }
}

