/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.Level;
import io.jstuff.log.Logger;
import java.time.Clock;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class AbstractLogger
implements Logger {
    private final String name;
    private Level level;
    private final Clock clock;

    protected AbstractLogger(String name, Level level, Clock clock) {
        this.name = name;
        this.level = level;
        this.clock = clock;
    }

    public String getName() {
        return this.name;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = Objects.requireNonNull(level);
    }

    public Clock getClock() {
        return this.clock;
    }

    protected static void outputMultiLine(String message, Consumer<String> outputFunction) {
        int i;
        int n = message.length();
        if (n == 0) {
            outputFunction.accept(message);
            return;
        }
        int j = i = 0;
        while (true) {
            char ch;
            if (j == n) {
                outputFunction.accept(message.substring(i));
                return;
            }
            if ((ch = message.charAt(j++)) == '\n') {
                outputFunction.accept(message.substring(i, j - 1));
                if (j < n && message.charAt(j) == '\r') {
                    ++j;
                }
                if (j >= n) {
                    return;
                }
            } else {
                if (ch != '\r') continue;
                outputFunction.accept(message.substring(i, j - 1));
                if (j < n && message.charAt(j) == '\n') {
                    ++j;
                }
                if (j >= n) {
                    return;
                }
            }
            i = j;
        }
    }
}

