/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.util;

import io.jstuff.util.MiniSet;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class MiniSet1<T>
extends MiniSet<T> {
    private final T value;

    public MiniSet1(T value) {
        this.value = value;
    }

    public MiniSet1(Set<T> set) {
        if (set.size() != 1) {
            throw new IllegalArgumentException("MiniSet1 size must be 1");
        }
        this.value = set instanceof MiniSet1 ? ((MiniSet1)set).value : set.iterator().next();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return Objects.equals(o, this.value);
    }

    @Override
    public Iterator<T> iterator() {
        return new Miniterator();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.value};
    }

    @Override
    public <TT> TT[] toArray(TT[] a) {
        if (a.length == 0) {
            Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
            newArray[0] = this.value;
            return newArray;
        }
        a[0] = this.value;
        if (a.length > 1) {
            a[1] = null;
        }
        return a;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set otherSet = (Set)other;
        return otherSet.size() == 1 && otherSet.contains(this.value);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Override
    public String toString() {
        return "[" + this.stringOf(this.value) + ']';
    }

    public class Miniterator
    implements Iterator<T> {
        private boolean used = false;

        @Override
        public boolean hasNext() {
            return !this.used;
        }

        @Override
        public T next() {
            if (this.used) {
                throw new NoSuchElementException();
            }
            this.used = true;
            return MiniSet1.this.value;
        }
    }
}

