/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.util;

import io.jstuff.util.MiniMap;
import io.jstuff.util.MiniSet1;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MiniMap1<K, V>
extends MiniMap<K, V> {
    private final K key;
    private final V value;

    public MiniMap1(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public MiniMap1(Map<K, V> map) {
        if (map.size() != 1) {
            throw new IllegalArgumentException("MiniMap1 size must be 1");
        }
        if (map instanceof MiniMap1) {
            MiniMap1 miniMap1 = (MiniMap1)map;
            this.key = miniMap1.key;
            this.value = miniMap1.value;
        } else {
            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
            Map.Entry<K, V> entry = iterator.next();
            this.key = entry.getKey();
            this.value = entry.getValue();
        }
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return Objects.equals(this.key, key);
    }

    @Override
    public boolean containsValue(Object value) {
        return Objects.equals(this.value, value);
    }

    @Override
    public V get(Object key) {
        return Objects.equals(this.key, key) ? (V)this.value : null;
    }

    @Override
    public Set<K> keySet() {
        return new MiniSet1<K>(this.key);
    }

    @Override
    public Collection<V> values() {
        return new MiniSet1<V>(this.value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new MiniSet1<Map.Entry<K, V>>(MiniMap1.entry(this.key, this.value));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        Map otherMap = (Map)other;
        return otherMap.size() == 1 && otherMap.containsKey(this.key) && Objects.equals(this.value, otherMap.get(this.key));
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
    }

    @Override
    public String toString() {
        return "{" + this.stringOf(this.key) + '=' + this.stringOf(this.value) + '}';
    }
}

