/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.util;

import io.jstuff.util.ImmutableCollection;
import java.util.Objects;
import java.util.Set;

public class ImmutableSet<T>
extends ImmutableCollection<T>
implements Set<T> {
    public ImmutableSet(T[] array, int length) {
        super(ImmutableSet.checkLength(array, length), array);
    }

    public ImmutableSet(T[] array) {
        super(array.length, array);
    }

    public ImmutableSet(Set<T> set) {
        super(set.size(), set.toArray(new Object[0]));
    }

    private ImmutableSet(int length, T[] array) {
        super(length, array);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set otherSet = (Set)other;
        if (this.length != otherSet.size()) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (otherSet.contains(this.array[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.length; ++i) {
            result += Objects.hashCode(this.array[i]);
        }
        return result;
    }

    public static <TT> ImmutableSet<TT> emptySet() {
        return new ImmutableSet<Object>(0, emptyArray);
    }

    public static <TT> ImmutableSet<TT> setOf(TT[] array) {
        int size = array.length;
        return size == 0 ? ImmutableSet.emptySet() : new ImmutableSet<TT>(size, array);
    }

    public static <TT> ImmutableSet<TT> setOf(TT[] array, int length) {
        return length == 0 ? ImmutableSet.emptySet() : new ImmutableSet<TT>((T[])array, length);
    }
}

