/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.util;

import io.jstuff.util.ImmutableCollectionBase;
import io.jstuff.util.ImmutableIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class ImmutableCollection<T>
extends ImmutableCollectionBase<T, T>
implements Collection<T> {
    public ImmutableCollection(T[] array, int length) {
        super(array, ImmutableCollection.checkLength(array, length));
    }

    public ImmutableCollection(T[] array) {
        super(array, array.length);
    }

    public ImmutableCollection(Collection<T> collection) {
        super(collection.toArray(new Object[0]), collection.size());
    }

    protected ImmutableCollection(int length, T[] array) {
        super(array, length);
    }

    @Override
    public boolean contains(Object o) {
        return ImmutableCollection.contains(this.array, this.length, o);
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator<Object>(this.array, this.length, 0);
    }

    @Override
    public Object[] toArray() {
        return this.length == 0 ? emptyArray : Arrays.copyOf(this.array, this.length);
    }

    @Override
    public <TT> TT[] toArray(TT[] a) {
        if (this.length == 0) {
            return emptyArray;
        }
        if (a.length < this.length) {
            return Arrays.copyOf(this.array, this.length, a.getClass());
        }
        TT[] target = a;
        System.arraycopy(this.array, 0, target, 0, this.length);
        if (target.length > this.length) {
            target[this.length] = null;
        }
        return a;
    }

    public T get(int index) {
        return (T)ImmutableCollection.get(this.array, this.length, index);
    }

    public static <TT> TT get(TT[] array, int length, int index) {
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return array[index];
    }

    public static <TT> boolean contains(TT[] array, int length, Object o) {
        if (o == null) {
            for (int i = 0; i < length; ++i) {
                if (array[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                if (!o.equals(array[i])) continue;
                return true;
            }
        }
        return false;
    }
}

