/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.orgjson.io;

import io.jsonwebtoken.io.DeserializationException;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class OrgJsonDeserializer
implements Deserializer<Object> {
    public Object deserialize(byte[] bytes) throws DeserializationException {
        Assert.notNull((Object)bytes, (String)"JSON byte array cannot be null");
        if (bytes.length == 0) {
            throw new DeserializationException("Invalid JSON: zero length byte array.");
        }
        try {
            String s = new String(bytes, Strings.UTF_8);
            return this.parse(s);
        }
        catch (Exception e) {
            String msg = "Invalid JSON: " + e.getMessage();
            throw new DeserializationException(msg, (Throwable)e);
        }
    }

    private Object parse(String json) throws JSONException {
        JSONTokener tokener = new JSONTokener(json);
        char c = tokener.nextClean();
        tokener.back();
        if (c == '{') {
            JSONObject o = new JSONObject(tokener);
            return this.toMap(o);
        }
        if (c == '[') {
            JSONArray a = new JSONArray(tokener);
            return this.toList(a);
        }
        Object value = tokener.nextValue();
        return this.convertIfNecessary(value);
    }

    private Map<String, Object> toMap(JSONObject o) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Iterator iterator = o.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = o.get(key);
            value = this.convertIfNecessary(value);
            map.put(key, value);
        }
        return map;
    }

    private List<Object> toList(JSONArray a) {
        int length = a.length();
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object value = a.get(i);
            value = this.convertIfNecessary(value);
            list.add(value);
        }
        return list;
    }

    private Object convertIfNecessary(Object v) {
        List<Object> value = v;
        if (JSONObject.NULL.equals(value)) {
            value = null;
        } else if (value instanceof JSONArray) {
            value = this.toList((JSONArray)value);
        } else if (value instanceof JSONObject) {
            value = this.toMap((JSONObject)value);
        }
        return value;
    }
}

