/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Clock;
import io.jsonwebtoken.CompressionCodec;
import io.jsonwebtoken.CompressionCodecResolver;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.IncorrectClaimException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtHandler;
import io.jsonwebtoken.JwtHandlerAdapter;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.MissingClaimException;
import io.jsonwebtoken.PrematureJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.impl.DefaultClaims;
import io.jsonwebtoken.impl.DefaultClock;
import io.jsonwebtoken.impl.DefaultHeader;
import io.jsonwebtoken.impl.DefaultJws;
import io.jsonwebtoken.impl.DefaultJwsHeader;
import io.jsonwebtoken.impl.DefaultJwt;
import io.jsonwebtoken.impl.JwtDeserializer;
import io.jsonwebtoken.impl.compression.DefaultCompressionCodecResolver;
import io.jsonwebtoken.impl.crypto.DefaultJwtSignatureValidator;
import io.jsonwebtoken.impl.crypto.JwtSignatureValidator;
import io.jsonwebtoken.impl.lang.LegacyServices;
import io.jsonwebtoken.io.Decoder;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.DateFormats;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.SignatureException;
import io.jsonwebtoken.security.WeakKeyException;
import java.security.Key;
import java.util.Date;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;

public class DefaultJwtParser
implements JwtParser {
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private byte[] keyBytes;
    private Key key;
    private SigningKeyResolver signingKeyResolver;
    private CompressionCodecResolver compressionCodecResolver = new DefaultCompressionCodecResolver();
    private Decoder<String, byte[]> base64UrlDecoder = Decoders.BASE64URL;
    private Deserializer<Map<String, ?>> deserializer;
    private Claims expectedClaims = new DefaultClaims();
    private Clock clock = DefaultClock.INSTANCE;
    private long allowedClockSkewMillis = 0L;

    @Deprecated
    public DefaultJwtParser() {
    }

    DefaultJwtParser(SigningKeyResolver signingKeyResolver, Key key, byte[] keyBytes, Clock clock, long allowedClockSkewMillis, Claims expectedClaims, Decoder<String, byte[]> base64UrlDecoder, Deserializer<Map<String, ?>> deserializer, CompressionCodecResolver compressionCodecResolver) {
        this.signingKeyResolver = signingKeyResolver;
        this.key = key;
        this.keyBytes = keyBytes;
        this.clock = clock;
        this.allowedClockSkewMillis = allowedClockSkewMillis;
        this.expectedClaims = expectedClaims;
        this.base64UrlDecoder = base64UrlDecoder;
        this.deserializer = deserializer;
        this.compressionCodecResolver = compressionCodecResolver;
    }

    public JwtParser deserializeJsonWith(Deserializer<Map<String, ?>> deserializer) {
        Assert.notNull(deserializer, (String)"deserializer cannot be null.");
        this.deserializer = new JwtDeserializer(deserializer);
        return this;
    }

    public JwtParser base64UrlDecodeWith(Decoder<String, byte[]> base64UrlDecoder) {
        Assert.notNull(base64UrlDecoder, (String)"base64UrlDecoder cannot be null.");
        this.base64UrlDecoder = base64UrlDecoder;
        return this;
    }

    public JwtParser requireIssuedAt(Date issuedAt) {
        this.expectedClaims.setIssuedAt(issuedAt);
        return this;
    }

    public JwtParser requireIssuer(String issuer) {
        this.expectedClaims.setIssuer(issuer);
        return this;
    }

    public JwtParser requireAudience(String audience) {
        this.expectedClaims.setAudience(audience);
        return this;
    }

    public JwtParser requireSubject(String subject) {
        this.expectedClaims.setSubject(subject);
        return this;
    }

    public JwtParser requireId(String id) {
        this.expectedClaims.setId(id);
        return this;
    }

    public JwtParser requireExpiration(Date expiration) {
        this.expectedClaims.setExpiration(expiration);
        return this;
    }

    public JwtParser requireNotBefore(Date notBefore) {
        this.expectedClaims.setNotBefore(notBefore);
        return this;
    }

    public JwtParser require(String claimName, Object value) {
        Assert.hasText((String)claimName, (String)"claim name cannot be null or empty.");
        Assert.notNull((Object)value, (String)("The value cannot be null for claim name: " + claimName));
        this.expectedClaims.put((Object)claimName, value);
        return this;
    }

    public JwtParser setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"Clock instance cannot be null.");
        this.clock = clock;
        return this;
    }

    public JwtParser setAllowedClockSkewSeconds(long seconds) throws IllegalArgumentException {
        Assert.isTrue((seconds <= 9223372036854775L ? 1 : 0) != 0, (String)"Illegal allowedClockSkewMillis value: multiplying this value by 1000 to obtain the number of milliseconds would cause a numeric overflow.");
        this.allowedClockSkewMillis = Math.max(0L, seconds * 1000L);
        return this;
    }

    public JwtParser setSigningKey(byte[] key) {
        Assert.notEmpty((byte[])key, (String)"signing key cannot be null or empty.");
        this.keyBytes = key;
        return this;
    }

    public JwtParser setSigningKey(String base64EncodedSecretKey) {
        Assert.hasText((String)base64EncodedSecretKey, (String)"signing key cannot be null or empty.");
        this.keyBytes = (byte[])Decoders.BASE64.decode((Object)base64EncodedSecretKey);
        return this;
    }

    public JwtParser setSigningKey(Key key) {
        Assert.notNull((Object)key, (String)"signing key cannot be null.");
        this.key = key;
        return this;
    }

    public JwtParser setSigningKeyResolver(SigningKeyResolver signingKeyResolver) {
        Assert.notNull((Object)signingKeyResolver, (String)"SigningKeyResolver cannot be null.");
        this.signingKeyResolver = signingKeyResolver;
        return this;
    }

    public JwtParser setCompressionCodecResolver(CompressionCodecResolver compressionCodecResolver) {
        Assert.notNull((Object)compressionCodecResolver, (String)"compressionCodecResolver cannot be null.");
        this.compressionCodecResolver = compressionCodecResolver;
        return this;
    }

    public boolean isSigned(String jwt) {
        if (jwt == null) {
            return false;
        }
        int delimiterCount = 0;
        for (int i = 0; i < jwt.length(); ++i) {
            char c = jwt.charAt(i);
            if (delimiterCount == 2) {
                return !Character.isWhitespace(c) && c != '.';
            }
            if (c != '.') continue;
            ++delimiterCount;
        }
        return false;
    }

    public Jwt parse(String jwt) throws ExpiredJwtException, MalformedJwtException, SignatureException {
        String body;
        boolean allowSkew;
        if (this.deserializer == null) {
            this.deserializeJsonWith(LegacyServices.loadFirst(Deserializer.class));
        }
        Assert.hasText((String)jwt, (String)"JWT String argument cannot be null or empty.");
        if ("..".equals(jwt)) {
            String msg = "JWT string '..' is missing a header.";
            throw new MalformedJwtException(msg);
        }
        String base64UrlEncodedHeader = null;
        String base64UrlEncodedPayload = null;
        String base64UrlEncodedDigest = null;
        int delimiterCount = 0;
        StringBuilder sb = new StringBuilder(128);
        for (char c : jwt.toCharArray()) {
            if (c == '.') {
                String token;
                CharSequence tokenSeq = Strings.clean((CharSequence)sb);
                String string = token = tokenSeq != null ? tokenSeq.toString() : null;
                if (delimiterCount == 0) {
                    base64UrlEncodedHeader = token;
                } else if (delimiterCount == 1) {
                    base64UrlEncodedPayload = token;
                }
                ++delimiterCount;
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (delimiterCount != 2) {
            String msg = "JWT strings must contain exactly 2 period characters. Found: " + delimiterCount;
            throw new MalformedJwtException(msg);
        }
        if (sb.length() > 0) {
            base64UrlEncodedDigest = sb.toString();
        }
        DefaultHeader header = null;
        CompressionCodec compressionCodec = null;
        if (base64UrlEncodedHeader != null) {
            byte[] bytes = (byte[])this.base64UrlDecoder.decode(base64UrlEncodedHeader);
            String origValue = new String(bytes, Strings.UTF_8);
            Map<String, Object> m = this.readValue(origValue);
            header = base64UrlEncodedDigest != null ? new DefaultJwsHeader(m) : new DefaultHeader(m);
            compressionCodec = this.compressionCodecResolver.resolveCompressionCodec((Header)header);
        }
        String payload = "";
        if (base64UrlEncodedPayload != null) {
            byte[] bytes = (byte[])this.base64UrlDecoder.decode(base64UrlEncodedPayload);
            if (compressionCodec != null) {
                bytes = compressionCodec.decompress(bytes);
            }
            payload = new String(bytes, Strings.UTF_8);
        }
        Object claims = null;
        if (!payload.isEmpty() && payload.charAt(0) == '{' && payload.charAt(payload.length() - 1) == '}') {
            Map<String, ?> claimsMap = this.readValue(payload);
            claims = new DefaultClaims(claimsMap);
        }
        if (base64UrlEncodedDigest != null) {
            JwtSignatureValidator validator;
            String alg;
            JwsHeader jwsHeader = header;
            SignatureAlgorithm algorithm = null;
            if (header != null && Strings.hasText((String)(alg = jwsHeader.getAlgorithm()))) {
                algorithm = SignatureAlgorithm.forName((String)alg);
            }
            if (algorithm == null || algorithm == SignatureAlgorithm.NONE) {
                String msg = "JWT string has a digest/signature, but the header does not reference a valid signature algorithm.";
                throw new MalformedJwtException(msg);
            }
            if (this.key != null && this.keyBytes != null) {
                throw new IllegalStateException("A key object and key bytes cannot both be specified. Choose either.");
            }
            if ((this.key != null || this.keyBytes != null) && this.signingKeyResolver != null) {
                String object = this.key != null ? "a key object" : "key bytes";
                throw new IllegalStateException("A signing key resolver and " + object + " cannot both be specified. Choose either.");
            }
            Key key = this.key;
            if (key == null) {
                byte[] keyBytes = this.keyBytes;
                if (Objects.isEmpty((byte[])keyBytes) && this.signingKeyResolver != null) {
                    key = claims != null ? this.signingKeyResolver.resolveSigningKey(jwsHeader, (Claims)claims) : this.signingKeyResolver.resolveSigningKey(jwsHeader, payload);
                }
                if (!Objects.isEmpty((byte[])keyBytes)) {
                    Assert.isTrue((boolean)algorithm.isHmac(), (String)"Key bytes can only be specified for HMAC signatures. Please specify a PublicKey or PrivateKey instance.");
                    key = new SecretKeySpec(keyBytes, algorithm.getJcaName());
                }
            }
            Assert.notNull((Object)key, (String)"A signing key must be specified if the specified JWT is digitally signed.");
            String jwtWithoutSignature = base64UrlEncodedHeader + '.';
            if (base64UrlEncodedPayload != null) {
                jwtWithoutSignature = jwtWithoutSignature + base64UrlEncodedPayload;
            }
            try {
                algorithm.assertValidVerificationKey(key);
                validator = this.createSignatureValidator(algorithm, key);
            }
            catch (WeakKeyException e) {
                throw e;
            }
            catch (InvalidKeyException | IllegalArgumentException e) {
                String algName = algorithm.getValue();
                String msg = "The parsed JWT indicates it was signed with the " + algName + " signature " + "algorithm, but the specified signing key of type " + key.getClass().getName() + " may not be used to validate " + algName + " signatures.  Because the specified " + "signing key reflects a specific and expected algorithm, and the JWT does not reflect " + "this algorithm, it is likely that the JWT was not expected and therefore should not be " + "trusted.  Another possibility is that the parser was configured with the incorrect " + "signing key, but this cannot be assumed for security reasons.";
                throw new UnsupportedJwtException(msg, e);
            }
            if (!validator.isValid(jwtWithoutSignature, base64UrlEncodedDigest)) {
                String msg = "JWT signature does not match locally computed signature. JWT validity cannot be asserted and should not be trusted.";
                throw new SignatureException(msg);
            }
        }
        boolean bl = allowSkew = this.allowedClockSkewMillis > 0L;
        if (claims != null) {
            Date nbf;
            Date now = this.clock.now();
            long nowTime = now.getTime();
            Date exp = claims.getExpiration();
            if (exp != null) {
                Date max;
                long maxTime = nowTime - this.allowedClockSkewMillis;
                Date date = max = allowSkew ? new Date(maxTime) : now;
                if (max.after(exp)) {
                    String expVal = DateFormats.formatIso8601((Date)exp, (boolean)false);
                    String nowVal = DateFormats.formatIso8601((Date)now, (boolean)false);
                    long differenceMillis = maxTime - exp.getTime();
                    String msg = "JWT expired at " + expVal + ". Current time: " + nowVal + ", a difference of " + differenceMillis + " milliseconds.  Allowed clock skew: " + this.allowedClockSkewMillis + " milliseconds.";
                    throw new ExpiredJwtException((Header)header, (Claims)claims, msg);
                }
            }
            if ((nbf = claims.getNotBefore()) != null) {
                Date min;
                long minTime = nowTime + this.allowedClockSkewMillis;
                Date date = min = allowSkew ? new Date(minTime) : now;
                if (min.before(nbf)) {
                    String nbfVal = DateFormats.formatIso8601((Date)nbf, (boolean)false);
                    String nowVal = DateFormats.formatIso8601((Date)now, (boolean)false);
                    long differenceMillis = nbf.getTime() - minTime;
                    String msg = "JWT must not be accepted before " + nbfVal + ". Current time: " + nowVal + ", a difference of " + differenceMillis + " milliseconds.  Allowed clock skew: " + this.allowedClockSkewMillis + " milliseconds.";
                    throw new PrematureJwtException((Header)header, (Claims)claims, msg);
                }
            }
            this.validateExpectedClaims(header, (Claims)claims);
        }
        String string = body = claims != null ? claims : payload;
        if (base64UrlEncodedDigest != null) {
            return new DefaultJws<String>((JwsHeader)header, body, base64UrlEncodedDigest);
        }
        return new DefaultJwt<String>(header, body);
    }

    private static Object normalize(Object o) {
        if (o instanceof Integer) {
            o = ((Integer)o).longValue();
        }
        return o;
    }

    private void validateExpectedClaims(Header header, Claims claims) {
        for (String expectedClaimName : this.expectedClaims.keySet()) {
            String msg;
            Object expectedClaimValue = DefaultJwtParser.normalize(this.expectedClaims.get((Object)expectedClaimName));
            Object actualClaimValue = DefaultJwtParser.normalize(claims.get((Object)expectedClaimName));
            if (expectedClaimValue instanceof Date) {
                try {
                    actualClaimValue = claims.get(expectedClaimName, Date.class);
                }
                catch (Exception e) {
                    msg = "JWT Claim '" + expectedClaimName + "' was expected to be a Date, but its value " + "cannot be converted to a Date using current heuristics.  Value: " + actualClaimValue;
                    throw new IncorrectClaimException(header, claims, msg);
                }
            }
            MissingClaimException invalidClaimException = null;
            if (actualClaimValue == null) {
                msg = String.format("Expected %s claim to be: %s, but was not present in the JWT claims.", expectedClaimName, expectedClaimValue);
                invalidClaimException = new MissingClaimException(header, claims, msg);
            } else if (!expectedClaimValue.equals(actualClaimValue)) {
                msg = String.format("Expected %s claim to be: %s, but was: %s.", expectedClaimName, expectedClaimValue, actualClaimValue);
                invalidClaimException = new IncorrectClaimException(header, claims, msg);
            }
            if (invalidClaimException == null) continue;
            invalidClaimException.setClaimName(expectedClaimName);
            invalidClaimException.setClaimValue(expectedClaimValue);
            throw invalidClaimException;
        }
    }

    protected JwtSignatureValidator createSignatureValidator(SignatureAlgorithm alg, Key key) {
        return new DefaultJwtSignatureValidator(alg, key, this.base64UrlDecoder);
    }

    public <T> T parse(String compact, JwtHandler<T> handler) throws ExpiredJwtException, MalformedJwtException, SignatureException {
        Assert.notNull(handler, (String)"JwtHandler argument cannot be null.");
        Assert.hasText((String)compact, (String)"JWT String argument cannot be null or empty.");
        Jwt jwt = this.parse(compact);
        if (jwt instanceof Jws) {
            Jws jws = (Jws)jwt;
            Object body = jws.getBody();
            if (body instanceof Claims) {
                return (T)handler.onClaimsJws(jws);
            }
            return (T)handler.onPlaintextJws(jws);
        }
        Object body = jwt.getBody();
        if (body instanceof Claims) {
            return (T)handler.onClaimsJwt(jwt);
        }
        return (T)handler.onPlaintextJwt(jwt);
    }

    public Jwt<Header, String> parsePlaintextJwt(String plaintextJwt) {
        return (Jwt)this.parse(plaintextJwt, (JwtHandler)new JwtHandlerAdapter<Jwt<Header, String>>(){

            public Jwt<Header, String> onPlaintextJwt(Jwt<Header, String> jwt) {
                return jwt;
            }
        });
    }

    public Jwt<Header, Claims> parseClaimsJwt(String claimsJwt) {
        try {
            return (Jwt)this.parse(claimsJwt, (JwtHandler)new JwtHandlerAdapter<Jwt<Header, Claims>>(){

                public Jwt<Header, Claims> onClaimsJwt(Jwt<Header, Claims> jwt) {
                    return jwt;
                }
            });
        }
        catch (IllegalArgumentException iae) {
            throw new UnsupportedJwtException("Signed JWSs are not supported.", (Throwable)iae);
        }
    }

    public Jws<String> parsePlaintextJws(String plaintextJws) {
        try {
            return (Jws)this.parse(plaintextJws, (JwtHandler)new JwtHandlerAdapter<Jws<String>>(){

                public Jws<String> onPlaintextJws(Jws<String> jws) {
                    return jws;
                }
            });
        }
        catch (IllegalArgumentException iae) {
            throw new UnsupportedJwtException("Signed JWSs are not supported.", (Throwable)iae);
        }
    }

    public Jws<Claims> parseClaimsJws(String claimsJws) {
        return (Jws)this.parse(claimsJws, (JwtHandler)new JwtHandlerAdapter<Jws<Claims>>(){

            public Jws<Claims> onClaimsJws(Jws<Claims> jws) {
                return jws;
            }
        });
    }

    protected Map<String, ?> readValue(String val) {
        byte[] bytes = val.getBytes(Strings.UTF_8);
        return (Map)this.deserializer.deserialize(bytes);
    }
}

