/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.util;

import io.joynr.exceptions.JoynrIllegalStateException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastWildcardRegexFactory {
    private static final Logger logger = LoggerFactory.getLogger(MulticastWildcardRegexFactory.class);

    public Pattern createIdPattern(String multicastId) {
        this.verifyMulticastIdValid(multicastId);
        if (multicastId.matches("^\\*$")) {
            logger.trace("Creating multicast ID regex pattern: {}", (Object)".+");
            return Pattern.compile(".+");
        }
        Object patternString = multicastId.replaceAll("^\\+(/)?", "[^\\/]+$1");
        if (((String)(patternString = ((String)patternString).replaceAll("/\\+/", "/[^\\/]+/"))).endsWith("/+")) {
            patternString = ((String)patternString).substring(0, ((String)patternString).length() - 1);
            patternString = (String)patternString + "[^/]+$";
        } else if (((String)patternString).endsWith("/*")) {
            patternString = ((String)patternString).substring(0, ((String)patternString).length() - 2);
            patternString = (String)patternString + "(/.*)?$";
        }
        logger.trace("Creating multicast ID regex pattern: {}", patternString);
        return Pattern.compile((String)patternString);
    }

    private void verifyMulticastIdValid(String multicastId) {
        boolean invalid;
        boolean bl = invalid = Pattern.compile("[^/]\\+").matcher(multicastId).find() || Pattern.compile("\\+[^/]").matcher(multicastId).find() || !"*".equals(multicastId) && multicastId.contains("*") && !multicastId.matches(".*/\\*$");
        if (invalid) {
            throw new JoynrIllegalStateException("Multicast IDs may only contain '+' as a placeholder for a partition, and '*' as only character or right at the end after a '/'. You passed in: " + multicastId);
        }
    }
}

