/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.messaging.MulticastReceiverRegistrar;
import io.joynr.messaging.routing.MessageRouter;
import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.Deferred;
import io.joynr.provider.DeferredVoid;
import io.joynr.provider.Promise;
import joynr.exceptions.ProviderRuntimeException;
import joynr.system.RoutingAbstractProvider;
import joynr.system.RoutingProvider;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.BinderAddress;
import joynr.system.RoutingTypes.BrowserAddress;
import joynr.system.RoutingTypes.ChannelAddress;
import joynr.system.RoutingTypes.MqttAddress;
import joynr.system.RoutingTypes.RoutingTypesUtil;
import joynr.system.RoutingTypes.UdsAddress;
import joynr.system.RoutingTypes.UdsClientAddress;
import joynr.system.RoutingTypes.WebSocketAddress;
import joynr.system.RoutingTypes.WebSocketClientAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingProviderImpl
extends RoutingAbstractProvider {
    private MessageRouter messageRouter;
    private MulticastReceiverRegistrar multicastReceiverRegistrar;
    private String globalAddressString;
    private String replyToAddressString;
    private static final Logger logger = LoggerFactory.getLogger(RoutingProviderImpl.class);
    @Inject(optional=true)
    @Named(value="property_mqtt_global_address")
    private Address globalAddress = new Address();
    @Inject(optional=true)
    @Named(value="property_mqtt_reply_to_address")
    private Address replyToAddress = new Address();

    @Inject
    public RoutingProviderImpl(MessageRouter messageRouter, MulticastReceiverRegistrar multicastReceiverRegistrar) {
        this.messageRouter = messageRouter;
        this.multicastReceiverRegistrar = multicastReceiverRegistrar;
    }

    @Inject
    public void init() {
        this.globalAddressString = RoutingTypesUtil.toAddressString((Address)this.globalAddress);
        this.replyToAddressString = RoutingTypesUtil.toAddressString((Address)this.replyToAddress);
    }

    private Promise<DeferredVoid> resolvedDeferred() {
        DeferredVoid deferred = new DeferredVoid();
        deferred.resolve();
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> addNextHop(String participantId, ChannelAddress address, Boolean isGloballyVisible) {
        throw new IllegalArgumentException(ChannelAddress.class.getCanonicalName() + " no longer supported.");
    }

    public Promise<DeferredVoid> addNextHop(String participantId, MqttAddress address, Boolean isGloballyVisible) {
        this.messageRouter.addNextHop(participantId, (Address)address, isGloballyVisible);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> addNextHop(String participantId, BrowserAddress address, Boolean isGloballyVisible) {
        throw new IllegalArgumentException(BrowserAddress.class.getCanonicalName() + " no longer supported.");
    }

    public Promise<DeferredVoid> addNextHop(String participantId, WebSocketAddress address, Boolean isGloballyVisible) {
        this.messageRouter.addNextHop(participantId, (Address)address, isGloballyVisible);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> addNextHop(String participantId, UdsAddress address, Boolean isGloballyVisible) {
        DeferredVoid deferred = new DeferredVoid();
        String message = "UdsAddress is not supported in Java";
        logger.error("UdsAddress is not supported in Java");
        deferred.reject(new ProviderRuntimeException("UdsAddress is not supported in Java"));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> addNextHop(String participantId, BinderAddress binderAddress, Boolean isGloballyVisible) {
        this.messageRouter.addNextHop(participantId, (Address)binderAddress, isGloballyVisible);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> addNextHop(String participantId, WebSocketClientAddress address, Boolean isGloballyVisible) {
        this.messageRouter.addNextHop(participantId, (Address)address, isGloballyVisible);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> addNextHop(String participantId, UdsClientAddress address, Boolean isGloballyVisible) {
        DeferredVoid deferred = new DeferredVoid();
        String msg = "UdsClientAddress is not supported in Java";
        logger.error("UdsClientAddress is not supported in Java");
        deferred.reject(new ProviderRuntimeException("UdsClientAddress is not supported in Java"));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> removeNextHop(String participantId) {
        this.messageRouter.removeNextHop(participantId);
        return this.resolvedDeferred();
    }

    public Promise<RoutingProvider.ResolveNextHopDeferred> resolveNextHop(String participantId) {
        boolean resolved = this.messageRouter.resolveNextHop(participantId);
        RoutingProvider.ResolveNextHopDeferred deferred = new RoutingProvider.ResolveNextHopDeferred();
        deferred.resolve(Boolean.valueOf(resolved));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> addMulticastReceiver(String multicastId, String subscriberParticipantId, String providerParticipantId) {
        this.multicastReceiverRegistrar.addMulticastReceiver(multicastId, subscriberParticipantId, providerParticipantId);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> removeMulticastReceiver(String multicastId, String subscriberParticipantId, String providerParticipantId) {
        this.multicastReceiverRegistrar.removeMulticastReceiver(multicastId, subscriberParticipantId, providerParticipantId);
        return this.resolvedDeferred();
    }

    public Promise<Deferred<String>> getGlobalAddress() {
        Deferred globalAddressDeferred = new Deferred();
        globalAddressDeferred.resolve((Object)this.globalAddressString);
        return new Promise((AbstractDeferred)globalAddressDeferred);
    }

    public Promise<Deferred<String>> getReplyToAddress() {
        Deferred replyToAddressDeferred = new Deferred();
        replyToAddressDeferred.resolve((Object)this.replyToAddressString);
        return new Promise((AbstractDeferred)replyToAddressDeferred);
    }
}

