/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import joynr.system.RoutingTypes.Address;

public class RoutingEntry {
    Address address;
    boolean isGloballyVisible;
    long expiryDateMs;
    boolean isSticky;
    long refCount;

    public RoutingEntry(Address address, boolean isGloballyVisible, long expiryDateMs, boolean isSticky) {
        this.setAddress(address);
        this.setIsGloballyVisible(isGloballyVisible);
        this.expiryDateMs = expiryDateMs;
        this.isSticky = isSticky;
        this.refCount = 1L;
    }

    public Address getAddress() {
        return this.address;
    }

    public boolean getIsGloballyVisible() {
        return this.isGloballyVisible;
    }

    public long getExpiryDateMs() {
        return this.expiryDateMs;
    }

    public boolean getIsSticky() {
        return this.isSticky;
    }

    public long getRefCount() {
        return this.refCount;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setIsGloballyVisible(boolean isGloballyVisible) {
        this.isGloballyVisible = isGloballyVisible;
    }

    public void setExpiryDateMs(long expiryDateMs) {
        this.expiryDateMs = expiryDateMs;
    }

    public void setIsSticky(boolean isSticky) {
        this.isSticky = isSticky;
    }

    public void setRefCount(long refCount) {
        this.refCount = refCount;
    }

    public long incRefCount() {
        return ++this.refCount;
    }

    public long decRefCount() throws IllegalStateException {
        if (this.refCount <= 0L) {
            String exceptionMessage = "Reference count of the routing entry (" + this.address.toString() + ") is less or equal to 0. It could not be decremented.";
            throw new IllegalStateException(exceptionMessage);
        }
        return --this.refCount;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (int)(this.expiryDateMs ^ this.expiryDateMs >>> 32);
        result = 31 * result + (this.isGloballyVisible ? 1231 : 1237);
        result = 31 * result + (this.isSticky ? 1231 : 1237);
        result = 31 * result + (int)(this.refCount ^ this.refCount >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoutingEntry other = (RoutingEntry)obj;
        if (this.address == null ? other.address != null : !this.address.equals((Object)other.address)) {
            return false;
        }
        if (this.expiryDateMs != other.expiryDateMs) {
            return false;
        }
        if (this.isGloballyVisible != other.isGloballyVisible) {
            return false;
        }
        if (this.isSticky != other.isSticky) {
            return false;
        }
        return this.refCount == other.refCount;
    }
}

