/*
 * Decompiled with CFR 0.152.
 */
package io.jmix.gradle;

import io.jmix.gradle.AnnotationsInfo;
import io.jmix.gradle.BaseEnhancingStep;
import io.jmix.gradle.MetaModelUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class EntityEntryEnhancingStep
extends BaseEnhancingStep {
    @Override
    protected boolean isAlreadyEnhanced(CtClass ctClass) throws NotFoundException {
        return MetaModelUtil.isEntityEntryEnhanced(ctClass);
    }

    @Override
    protected String getEnhancingType() {
        return "Entity Entry Enhancer";
    }

    @Override
    protected void executeInternal(CtClass ctClass) throws IOException, CannotCompileException, NotFoundException {
        AnnotationsInfo info = AnnotationsInfo.forClass(ctClass);
        if (info.hasMetadataChanges()) {
            boolean embeddable = info.hasClassAnnotation(AnnotationsInfo.ClassAnnotation.EMBEDDABLE);
            boolean jmixEntity = info.hasClassAnnotation(AnnotationsInfo.ClassAnnotation.JMIX_ENTITY);
            if (info.getPrimaryKey() != null) {
                this.makeEntityEntryClass(ctClass, info);
                this.makeEntityEntryField(ctClass);
                String entryClassName = String.format("%s.%s", ctClass.getName(), "JmixEntityEntry");
                this.makeEntityEntryMethods(ctClass, entryClassName);
                CtField generatedIdField = this.findGeneratedIdField(info);
                if (generatedIdField == null) {
                    this.initEntityEntry(ctClass, entryClassName);
                }
                if (!embeddable) {
                    this.makeJavaSystemMethods(ctClass, generatedIdField);
                }
            } else if (embeddable) {
                this.makeEntityEntryField(ctClass);
                this.makeEntityEntryMethods(ctClass, "io.jmix.core.entity.EmbeddableEntityEntry");
            } else if (jmixEntity) {
                this.makeEntityEntryField(ctClass);
                this.makeEntityEntryMethods(ctClass, "io.jmix.core.entity.NoIdEntityEntry");
                this.makeJavaSystemMethods(ctClass, null);
            }
        }
        ctClass.addInterface(this.classPool.get("io.jmix.core.entity.JmixEntityEntryEnhanced"));
    }

    protected void makeEntityEntryClass(CtClass ctClass, AnnotationsInfo info) throws CannotCompileException, NotFoundException, IOException {
        CtField entityIdField = Objects.requireNonNull(info.getPrimaryKey());
        CtClass nestedCtClass = ctClass.makeNestedClass("JmixEntityEntry", true);
        CtField generatedIdField = this.findGeneratedIdField(info);
        CtClass idType = this.classPool.get(Object.class.getName());
        if (generatedIdField == null) {
            nestedCtClass.setSuperclass(this.classPool.get("io.jmix.core.entity.NullableIdEntityEntry"));
        } else {
            nestedCtClass.setSuperclass(this.classPool.get("io.jmix.core.entity.BaseEntityEntry"));
        }
        CtMethod getIdMethod = CtNewMethod.make((CtClass)idType, (String)"getEntityId", null, null, (String)String.format("return ((%s)getSource()).get%s();", ctClass.getName(), StringUtils.capitalize((String)entityIdField.getName())), (CtClass)nestedCtClass);
        nestedCtClass.addMethod(getIdMethod);
        CtMethod setIdMethod = CtNewMethod.make((CtClass)CtClass.voidType, (String)"setEntityId", (CtClass[])new CtClass[]{idType}, null, (String)String.format("((%s)getSource()).set%s((%s)$1);", ctClass.getName(), StringUtils.capitalize((String)entityIdField.getName()), entityIdField.getType().getName()), (CtClass)nestedCtClass);
        nestedCtClass.addMethod(setIdMethod);
        if (generatedIdField != null) {
            CtMethod getGeneratedIdMethod = CtNewMethod.make((CtClass)idType, (String)"getGeneratedIdOrNull", null, null, (String)String.format("return ((%s)getSource()).get%s();", ctClass.getName(), StringUtils.capitalize((String)generatedIdField.getName())), (CtClass)nestedCtClass);
            nestedCtClass.addMethod(getGeneratedIdMethod);
            CtMethod setGeneratedIdMethod = CtNewMethod.make((CtClass)CtClass.voidType, (String)"setGeneratedId", (CtClass[])new CtClass[]{idType}, null, (String)String.format("((%s)getSource()).set%s((%s)$1);", ctClass.getName(), StringUtils.capitalize((String)generatedIdField.getName()), generatedIdField.getType().getName()), (CtClass)nestedCtClass);
            nestedCtClass.addMethod(setGeneratedIdMethod);
        }
        this.setupAuditing(nestedCtClass, ctClass, info);
        this.setupSoftDelete(nestedCtClass, ctClass, info);
        this.setupHasUuid(nestedCtClass, ctClass, info);
        this.setupVersion(nestedCtClass, ctClass, info);
        nestedCtClass.writeFile(this.outputDir);
    }

    @Nullable
    protected CtField findGeneratedIdField(AnnotationsInfo info) {
        CtField primaryKeyField = info.getPrimaryKey();
        List<CtField> generatedValueFields = info.getAnnotatedFields(AnnotationsInfo.FieldAnnotation.JMIX_GENERATED_VALUE);
        return generatedValueFields.stream().filter(ctField -> ctField.equals(primaryKeyField)).findFirst().orElseGet(() -> generatedValueFields.stream().filter(this::isFieldOfUuidType).findFirst().orElse(null));
    }

    protected boolean isFieldOfUuidType(CtField ctField) {
        try {
            return ctField.getType().getName().equals("java.util.UUID");
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
    }

    private void setupSoftDelete(CtClass nestedClass, CtClass ctClass, AnnotationsInfo info) throws NotFoundException, CannotCompileException {
        CtField deletedDateField = info.getAnnotatedField(AnnotationsInfo.FieldAnnotation.DELETED_DATE);
        CtField deletedByField = info.getAnnotatedField(AnnotationsInfo.FieldAnnotation.DELETED_BY);
        if (deletedDateField != null) {
            this.createObjectSetter("DeletedDate", deletedDateField, nestedClass, ctClass);
            this.createObjectGetter("DeletedDate", deletedDateField, nestedClass, ctClass);
            this.createTypeGetter("DeletedDate", deletedDateField, nestedClass, ctClass);
            this.createObjectSetter("DeletedBy", deletedByField, nestedClass, ctClass);
            this.createObjectGetter("DeletedBy", deletedByField, nestedClass, ctClass);
            this.createTypeGetter("DeletedBy", deletedByField, nestedClass, ctClass);
            CtMethod isDeletedMethod = CtNewMethod.make((CtClass)CtClass.booleanType, (String)"isDeleted", null, null, (String)String.format("return ((%s)getSource()).get%s() != null;", ctClass.getName(), StringUtils.capitalize((String)deletedDateField.getName())), (CtClass)nestedClass);
            nestedClass.addMethod(isDeletedMethod);
            this.logger.debug(String.format("Entity %s is soft-deletable. Fields: deletedDate: %s, deletedBy: %s", ctClass.getSimpleName(), deletedDateField.getName(), deletedByField == null ? Character.valueOf('-') : deletedByField.getName()));
            nestedClass.addInterface(this.classPool.get("io.jmix.core.entity.EntityEntrySoftDelete"));
        } else if (deletedByField != null) {
            throw new RuntimeException("@DeletedBy annotation cannot be used without @DeletedDate. Class: " + ctClass.getName());
        }
    }

    protected void setupAuditing(CtClass nestedClass, CtClass ctClass, AnnotationsInfo info) throws NotFoundException, CannotCompileException {
        CtField createdDateField = info.getAnnotatedField(AnnotationsInfo.FieldAnnotation.CREATED_DATE);
        CtField createdByField = info.getAnnotatedField(AnnotationsInfo.FieldAnnotation.CREATED_BY);
        CtField lastModifiedDateField = info.getAnnotatedField(AnnotationsInfo.FieldAnnotation.LAST_MODIFIED_DATE);
        CtField lastModifiedByField = info.getAnnotatedField(AnnotationsInfo.FieldAnnotation.LAST_MODIFIED_BY);
        this.createObjectSetter("CreatedDate", createdDateField, nestedClass, ctClass);
        this.createObjectGetter("CreatedDate", createdDateField, nestedClass, ctClass);
        this.createTypeGetter("CreatedDate", createdDateField, nestedClass, ctClass);
        this.createObjectSetter("CreatedBy", createdByField, nestedClass, ctClass);
        this.createObjectGetter("CreatedBy", createdByField, nestedClass, ctClass);
        this.createTypeGetter("CreatedBy", createdByField, nestedClass, ctClass);
        this.createObjectSetter("LastModifiedDate", lastModifiedDateField, nestedClass, ctClass);
        this.createObjectGetter("LastModifiedDate", lastModifiedDateField, nestedClass, ctClass);
        this.createTypeGetter("LastModifiedDate", lastModifiedDateField, nestedClass, ctClass);
        this.createObjectSetter("LastModifiedBy", lastModifiedByField, nestedClass, ctClass);
        this.createObjectGetter("LastModifiedBy", lastModifiedByField, nestedClass, ctClass);
        this.createTypeGetter("LastModifiedBy", lastModifiedByField, nestedClass, ctClass);
        if (createdDateField != null || createdByField != null || lastModifiedDateField != null || lastModifiedByField != null) {
            nestedClass.addInterface(this.classPool.get("io.jmix.core.entity.EntityEntryAuditable"));
            this.logger.debug(String.format("Auditing enabled for %s. Fields: createdDate: %s, createdBy: %s, lastModifiedDate: %s, lastModifiedBy: %s", ctClass.getSimpleName(), createdDateField == null ? Character.valueOf('-') : createdDateField.getName(), createdByField == null ? Character.valueOf('-') : createdByField.getName(), lastModifiedDateField == null ? Character.valueOf('-') : lastModifiedDateField.getName(), lastModifiedByField == null ? Character.valueOf('-') : lastModifiedByField.getName()));
        }
    }

    protected void setupHasUuid(CtClass nestedClass, CtClass ctClass, AnnotationsInfo info) throws NotFoundException, CannotCompileException {
        String uuidFieldName;
        if (info.hasClassAnnotation(AnnotationsInfo.ClassAnnotation.LEGACY_HAS_UUID)) {
            uuidFieldName = "uuid";
        } else {
            List generatedValueUuidFields = info.getAnnotatedFields(AnnotationsInfo.FieldAnnotation.JMIX_GENERATED_VALUE).stream().filter(this::isFieldOfUuidType).collect(Collectors.toList());
            if (generatedValueUuidFields.size() > 1) {
                throw new RuntimeException("More than one UUID field annotated with @JmixGeneratedValue: " + generatedValueUuidFields.stream().map(field -> field.getDeclaringClass().getSimpleName() + "#" + field.getName()).collect(Collectors.joining(", ", "", ".")));
            }
            uuidFieldName = generatedValueUuidFields.size() == 1 ? ((CtField)generatedValueUuidFields.get(0)).getName() : null;
        }
        if (uuidFieldName != null) {
            this.setupHasUuidForField(nestedClass, ctClass, uuidFieldName);
        }
    }

    protected void setupVersion(CtClass nestedClass, CtClass ctClass, AnnotationsInfo info) throws NotFoundException, CannotCompileException {
        CtField versionField = info.getAnnotatedField(AnnotationsInfo.FieldAnnotation.VERSION);
        if (versionField != null) {
            this.createObjectSetter("Version", versionField, nestedClass, ctClass);
            this.createObjectGetter("Version", versionField, nestedClass, ctClass);
            nestedClass.addInterface(this.classPool.get("io.jmix.core.entity.EntityEntryVersioned"));
            this.logger.debug(String.format("Versioned enabled for %s. Fields: version: %s", ctClass.getSimpleName(), versionField.getName()));
        }
    }

    protected void setupHasUuidForField(CtClass nestedClass, CtClass ctClass, String uuidFieldName) throws NotFoundException, CannotCompileException {
        CtClass uuidClass = this.classPool.get(UUID.class.getName());
        nestedClass.addMethod(CtNewMethod.make((CtClass)uuidClass, (String)"getUuid", null, null, (String)String.format("return ((%s)getSource()).get%s();", ctClass.getName(), StringUtils.capitalize((String)uuidFieldName)), (CtClass)nestedClass));
        nestedClass.addMethod(CtNewMethod.make((CtClass)CtClass.voidType, (String)"setUuid", (CtClass[])new CtClass[]{uuidClass}, null, (String)String.format("((%s)getSource()).set%s($1);", ctClass.getName(), StringUtils.capitalize((String)uuidFieldName)), (CtClass)nestedClass));
        this.logger.debug(String.format("Entity '%s' uuid field: %s", ctClass.getSimpleName(), uuidFieldName));
        nestedClass.addInterface(this.classPool.get("io.jmix.core.entity.EntityEntryHasUuid"));
    }

    protected void createObjectSetter(String propName, @Nullable CtField propField, CtClass nestedClass, CtClass ctClass) throws CannotCompileException, NotFoundException {
        if (propField == null) {
            return;
        }
        CtClass objectClass = this.classPool.get(Object.class.getName());
        nestedClass.addMethod(CtNewMethod.make((CtClass)CtClass.voidType, (String)("set" + propName), (CtClass[])new CtClass[]{objectClass}, null, (String)String.format("((%s)getSource()).set%s((%s)$1);", ctClass.getName(), StringUtils.capitalize((String)propField.getName()), propField.getType().getName()), (CtClass)nestedClass));
    }

    protected void createObjectGetter(String propName, @Nullable CtField propField, CtClass nestedClass, CtClass ctClass) throws CannotCompileException, NotFoundException {
        if (propField == null) {
            return;
        }
        nestedClass.addMethod(CtNewMethod.make((CtClass)this.classPool.get(Object.class.getName()), (String)("get" + propName), null, null, (String)String.format("return ((%s)getSource()).get%s();", ctClass.getName(), StringUtils.capitalize((String)propField.getName())), (CtClass)nestedClass));
    }

    protected void createTypeGetter(String propName, @Nullable CtField propField, CtClass nestedClass, CtClass ctClass) throws CannotCompileException, NotFoundException {
        if (propField == null) {
            return;
        }
        CtClass classClass = this.classPool.get(Class.class.getName());
        nestedClass.addMethod(CtNewMethod.make((CtClass)classClass, (String)("get" + propName + "Class"), null, null, (String)String.format("return %s.class;", propField.getType().getName()), (CtClass)nestedClass));
    }

    protected void makeEntityEntryField(CtClass ctClass) throws CannotCompileException, NotFoundException {
        CtField ctField = new CtField(this.classPool.get("io.jmix.core.EntityEntry"), "_jmixEntityEntry", ctClass);
        ctField.setModifiers(2);
        ctClass.addField(ctField);
    }

    protected void makeEntityEntryMethods(CtClass ctClass, String entryClassName) throws NotFoundException, CannotCompileException {
        CtMethod entryMethod = CtNewMethod.make((CtClass)this.classPool.get("io.jmix.core.EntityEntry"), (String)"__getEntityEntry", null, null, (String)String.format("return %s == null ? %s = new %s(this) : %s;", "_jmixEntityEntry", "_jmixEntityEntry", entryClassName, "_jmixEntityEntry"), (CtClass)ctClass);
        ctClass.addMethod(entryMethod);
        CtMethod copyEntryMethod = CtNewMethod.make((CtClass)CtClass.voidType, (String)"__copyEntityEntry", null, null, (String)String.format("{ %s newEntityEntry = new %s(this); newEntityEntry.copy(%s) ; %s = newEntityEntry; }", entryClassName, entryClassName, "_jmixEntityEntry", "_jmixEntityEntry"), (CtClass)ctClass);
        ctClass.addMethod(copyEntryMethod);
    }

    private void initEntityEntry(CtClass ctClass, String entryClassName) throws CannotCompileException {
        CtConstructor constructor;
        try {
            constructor = ctClass.getDeclaredConstructor(null);
        }
        catch (NotFoundException e) {
            constructor = CtNewConstructor.defaultConstructor((CtClass)ctClass);
        }
        constructor.insertAfter(String.format("%s = new %s(this);", "_jmixEntityEntry", entryClassName));
    }

    protected void makeJavaSystemMethods(CtClass ctClass, CtField serializeFirstField) throws NotFoundException, CannotCompileException {
        this.makeEqualsMethod(ctClass);
        this.makeHashCodeMethod(ctClass);
        this.makeToStringMethod(ctClass);
        if (MetaModelUtil.findWriteObjectMethod(ctClass) == null && MetaModelUtil.findReadObjectMethod(ctClass) == null) {
            this.makeWriteObjectMethod(ctClass, serializeFirstField);
            this.makeReadObjectMethod(ctClass, serializeFirstField);
        }
    }

    protected void makeEqualsMethod(CtClass ctClass) throws NotFoundException, CannotCompileException {
        if (MetaModelUtil.findEqualsMethod(ctClass) == null) {
            CtMethod entryMethod = CtNewMethod.make((CtClass)CtClass.booleanType, (String)"equals", (CtClass[])new CtClass[]{this.classPool.get(Object.class.getName())}, null, (String)"return io.jmix.core.impl.EntityInternals.equals(this, $1);", (CtClass)ctClass);
            ctClass.addMethod(entryMethod);
        }
    }

    protected void makeHashCodeMethod(CtClass ctClass) throws NotFoundException, CannotCompileException {
        if (MetaModelUtil.findHashCodeMethod(ctClass) == null) {
            CtMethod entryMethod = CtNewMethod.make((CtClass)CtClass.intType, (String)"hashCode", null, null, (String)"return io.jmix.core.impl.EntityInternals.hashCode(this);", (CtClass)ctClass);
            ctClass.addMethod(entryMethod);
        }
    }

    protected void makeToStringMethod(CtClass ctClass) throws NotFoundException, CannotCompileException {
        if (MetaModelUtil.findToStringMethod(ctClass) == null) {
            CtMethod entryMethod = CtNewMethod.make((CtClass)this.classPool.get(String.class.getName()), (String)"toString", null, null, (String)"return io.jmix.core.impl.EntityInternals.toString(this);", (CtClass)ctClass);
            ctClass.addMethod(entryMethod);
        }
    }

    protected void makeReadObjectMethod(CtClass ctClass, CtField generatedIdField) throws NotFoundException, CannotCompileException {
        CtMethod entryMethod = CtNewMethod.make((int)2, (CtClass)CtClass.voidType, (String)"readObject", (CtClass[])new CtClass[]{this.classPool.get(ObjectInputStream.class.getName())}, (CtClass[])new CtClass[]{this.classPool.get(IOException.class.getName()), this.classPool.get(ClassNotFoundException.class.getName())}, (String)String.format("{ io.jmix.core.impl.EntityInternals.beforeReadObject(this, $1, %s); $1.defaultReadObject(); }", generatedIdField != null ? "\"" + generatedIdField.getName() + "\"" : "null"), (CtClass)ctClass);
        ctClass.addMethod(entryMethod);
    }

    protected void makeWriteObjectMethod(CtClass ctClass, CtField generatedIdField) throws NotFoundException, CannotCompileException {
        CtMethod entryMethod = CtNewMethod.make((int)2, (CtClass)CtClass.voidType, (String)"writeObject", (CtClass[])new CtClass[]{this.classPool.get(ObjectOutputStream.class.getName())}, (CtClass[])new CtClass[]{this.classPool.get(IOException.class.getName())}, (String)String.format("{ io.jmix.core.impl.EntityInternals.beforeWriteObject(this, $1, %s); $1.defaultWriteObject(); }", generatedIdField != null ? "\"" + generatedIdField.getName() + "\"" : "null"), (CtClass)ctClass);
        ctClass.addMethod(entryMethod);
    }
}

