/*
 * Decompiled with CFR 0.152.
 */
package io.jmix.gradle.ui;

import io.jmix.gradle.ClassPathUtil;
import io.jmix.gradle.ui.WidgetsTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;

public class WidgetsDebug
extends WidgetsTask {
    @Input
    protected String widgetSetsDir = "";
    @Input
    protected String widgetSetClass = "";
    @Input
    protected Map<String, Object> compilerArgs = new HashMap<String, Object>();
    @Input
    protected boolean printCompilerClassPath = false;
    @Input
    protected boolean shortClassPath = true;
    @Input
    protected String logLevel = "INFO";
    @Input
    protected String xmx = "-Xmx768m";
    @Input
    protected String xss = "-Xss8m";

    public WidgetsDebug() {
        this.setDescription("Debug GWT widgetset");
        this.setGroup("debug");
        this.dependsOn(new Object[]{this.getProject().getTasks().getByPath("classes")});
    }

    @TaskAction
    public void debugWidgets() {
        File widgetSetsDirectory;
        if (this.widgetSetClass == null || this.widgetSetClass.isEmpty()) {
            throw new IllegalStateException("Please specify \"String widgetSetClass\" for debug widgetset");
        }
        if (this.widgetSetsDir == null || this.widgetSetsDir.isEmpty()) {
            this.widgetSetsDir = this.getDefaultBuildDir().getAbsolutePath();
        }
        if ((widgetSetsDirectory = new File(this.widgetSetsDir)).exists()) {
            FileUtils.deleteQuietly((File)widgetSetsDirectory);
        }
        widgetSetsDirectory.mkdir();
        List<File> compilerClassPath = this.collectClassPathEntries();
        List<String> gwtCompilerArgs = this.collectCompilerArgs();
        List<String> gwtCompilerJvmArgs = this.collectCompilerJvmArgs();
        if (Os.isFamily((String)"windows") && this.shortClassPath) {
            File javaTmp = this.getProject().file((Object)"build/tmp/");
            if (javaTmp.exists()) {
                FileUtils.deleteQuietly((File)javaTmp);
            }
            javaTmp.mkdirs();
            File classPathFile = this.getProject().file((Object)"build/tmp/debug-widget-set-classpath.dat");
            ClassPathUtil.createClassPathFile(classPathFile, compilerClassPath);
            this.getProject().javaexec(spec -> {
                spec.setMain("io.jmix.gradle.ClassPathCommandLine");
                spec.setClasspath((FileCollection)this.getProject().files(new Object[]{ClassPathUtil.getCommandLineClassPath()}));
                spec.setArgs(ClassPathUtil.getExtendedCommandLineAgs(classPathFile.getAbsolutePath(), "com.google.gwt.dev.codeserver.CodeServer", gwtCompilerArgs));
                spec.setJvmArgs(gwtCompilerJvmArgs);
            });
        } else {
            this.getProject().javaexec(javaExecSpec -> {
                javaExecSpec.setMain("com.google.gwt.dev.codeserver.CodeServer");
                javaExecSpec.setClasspath((FileCollection)this.getProject().files(new Object[]{compilerClassPath}));
                javaExecSpec.setArgs(gwtCompilerArgs);
                javaExecSpec.setJvmArgs(gwtCompilerJvmArgs);
            });
        }
    }

    @Override
    @InputFiles
    public FileCollection getSourceFiles() {
        return super.getSourceFiles();
    }

    @OutputDirectory
    public File getOutputDirectory() {
        if (this.widgetSetsDir == null || this.widgetSetsDir.isEmpty()) {
            return this.getDefaultBuildDir();
        }
        return new File(this.widgetSetsDir);
    }

    @Internal
    protected File getDefaultBuildDir() {
        return new File(this.getProject().getBuildDir(), "/web-debug/VAADIN/widgetsets");
    }

    protected List<File> collectClassPathEntries() {
        StringBuilder sb;
        Configuration compileConfiguration;
        ArrayList<File> compilerClassPath = new ArrayList<File>();
        Configuration runtimeConfiguration = (Configuration)this.getProject().getConfigurations().findByName("runtime");
        if (runtimeConfiguration != null) {
            for (Object artifact : runtimeConfiguration.getResolvedConfiguration().getResolvedArtifacts()) {
                compilerClassPath.add(artifact.getFile());
            }
        }
        if ((compileConfiguration = (Configuration)this.getProject().getConfigurations().findByName("compile")) != null) {
            for (Project dependencyProject : this.collectProjectsWithDependency("vaadin-shared")) {
                SourceSet dependencyMainSourceSet = this.getSourceSet(dependencyProject, "main");
                compilerClassPath.addAll(dependencyMainSourceSet.getJava().getSrcDirs());
                compilerClassPath.addAll(this.getClassesDirs(dependencyMainSourceSet));
                compilerClassPath.add(dependencyMainSourceSet.getOutput().getResourcesDir());
                this.getProject().getLogger().debug(">> Widget set building Module: {}", (Object)dependencyProject.getName());
            }
        }
        SourceSet mainSourceSet = this.getSourceSet(this.getProject(), "main");
        compilerClassPath.addAll(mainSourceSet.getJava().getSrcDirs());
        compilerClassPath.addAll(this.getClassesDirs(mainSourceSet));
        compilerClassPath.add(mainSourceSet.getOutput().getResourcesDir());
        List compileClassPathArtifacts = StreamSupport.stream(mainSourceSet.getCompileClasspath().spliterator(), false).filter(f -> this.includedArtifact(f.getName()) && !compilerClassPath.contains(f)).collect(Collectors.toList());
        compilerClassPath.addAll(compileClassPathArtifacts);
        Configuration widgetsConfiguration = (Configuration)this.getProject().getConfigurations().findByName("widgets");
        if (widgetsConfiguration != null) {
            List widgetsDeps = widgetsConfiguration.getResolvedConfiguration().getFiles().stream().filter(f -> this.includedArtifact(f.getName()) && !compilerClassPath.contains(f)).collect(Collectors.toList());
            compilerClassPath.addAll(widgetsDeps);
        }
        if (this.getProject().getLogger().isEnabled(LogLevel.DEBUG)) {
            sb = new StringBuilder();
            for (File classPathEntry : compilerClassPath) {
                sb.append('\t').append(classPathEntry.getAbsolutePath()).append('\n');
            }
            this.getProject().getLogger().debug("GWT Compiler ClassPath: \n{}", (Object)sb.toString());
            this.getProject().getLogger().debug("");
        } else if (this.printCompilerClassPath) {
            sb = new StringBuilder();
            for (File classPathEntry : compilerClassPath) {
                sb.append('\t').append(classPathEntry.getAbsolutePath()).append('\n');
            }
            System.out.println("GWT Compiler ClassPath: \n" + sb.toString());
            System.out.println();
        }
        return compilerClassPath;
    }

    protected List<String> collectCompilerArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("-logLevel", this.logLevel));
        args.addAll(Arrays.asList("-workDir", this.getProject().file((Object)this.widgetSetsDir).getAbsolutePath()));
        for (File srcDir : this.getSourceSet(this.getProject(), "main").getJava().getSrcDirs()) {
            if (!srcDir.exists()) continue;
            args.addAll(Arrays.asList("-src", srcDir.getAbsolutePath()));
        }
        for (Project dependencyProject : this.collectProjectsWithDependency("vaadin-client")) {
            for (File srcDir : this.getSourceSet(dependencyProject, "main").getJava().getSrcDirs()) {
                if (!srcDir.exists()) continue;
                args.add("-src");
                args.add(srcDir.getAbsolutePath());
            }
        }
        HashMap<String, Object> gwtCompilerArgs = new HashMap<String, Object>();
        gwtCompilerArgs.put("-XmethodNameDisplayMode", "FULL");
        if (this.compilerArgs != null) {
            gwtCompilerArgs.putAll(this.compilerArgs);
        }
        for (Map.Entry entry : gwtCompilerArgs.entrySet()) {
            args.add((String)entry.getKey());
            args.add(String.valueOf(entry.getValue()));
        }
        args.add(this.widgetSetClass);
        if (this.getProject().getLogger().isInfoEnabled()) {
            System.out.println("GWT Compiler args: ");
            System.out.println('\t');
            System.out.println(args);
        }
        return args;
    }

    protected List<String> collectCompilerJvmArgs() {
        this.compilerJvmArgs.add(this.xmx);
        this.compilerJvmArgs.add(this.xss);
        if (this.getProject().getLogger().isInfoEnabled()) {
            System.out.println("JVM Args:");
            System.out.println('\t');
            System.out.println(this.compilerJvmArgs);
        }
        return new LinkedList<String>(this.compilerJvmArgs);
    }

    public void setWidgetSetsDir(String widgetSetsDir) {
        this.widgetSetsDir = widgetSetsDir;
    }

    public String getWidgetSetsDir() {
        return this.widgetSetsDir;
    }

    public void setWidgetSetClass(String widgetSetClass) {
        this.widgetSetClass = widgetSetClass;
    }

    public String getWidgetSetClass() {
        return this.widgetSetClass;
    }

    public void setCompilerArgs(Map<String, Object> compilerArgs) {
        this.compilerArgs = compilerArgs;
    }

    public Map<String, Object> getCompilerArgs() {
        return this.compilerArgs;
    }

    public void setPrintCompilerClassPath(boolean printCompilerClassPath) {
        this.printCompilerClassPath = printCompilerClassPath;
    }

    public boolean isPrintCompilerClassPath() {
        return this.printCompilerClassPath;
    }

    public boolean isShortClassPath() {
        return this.shortClassPath;
    }

    public void setShortClassPath(boolean shortClassPath) {
        this.shortClassPath = shortClassPath;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setXmx(String xmx) {
        this.xmx = xmx;
    }

    public String getXmx() {
        return this.xmx;
    }

    public void setXss(String xss) {
        this.xss = xss;
    }

    public String getXss() {
        return this.xss;
    }
}

