/*
 * Decompiled with CFR 0.152.
 */
package io.jmix.gradle.ui;

import com.google.common.base.Joiner;
import io.jmix.gradle.ClassPathUtil;
import io.jmix.gradle.ui.WidgetsTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;

public class WidgetsCompile
extends WidgetsTask {
    protected static final String GWT_XML_EXTENSION = "gwt.xml";
    protected static final String VAADIN_WIDGETSETS_MANIFEST_KEY = "Vaadin-Widgetsets";
    protected static Set<String> STANDARD_WIDGETSETS = new HashSet<String>(Arrays.asList("com.vaadin.v7.Vaadin7WidgetSet", "com.vaadin.DefaultWidgetSet"));
    @Input
    protected String widgetSetsDir = "";
    @Input
    protected String widgetSetClass = "";
    @Input
    protected Map<String, Object> compilerArgs = new HashMap<String, Object>();
    @Input
    protected boolean strict = true;
    @Input
    protected boolean draft = false;
    @Input
    protected boolean disableCastChecking = false;
    @Input
    protected int optimize = 9;
    @Input
    protected String style = "OBF";
    protected boolean generateWidgetSetFile = false;
    @Input
    protected String xmx = "-Xmx768m";
    @Input
    protected String xss = "-Xss8m";
    @Input
    protected String logLevel = "ERROR";
    @Input
    protected boolean shortClassPath = true;
    @Input
    protected int workers = Math.max(Runtime.getRuntime().availableProcessors() - 1, 1);
    @Input
    protected boolean printCompilerClassPath = false;

    public WidgetsCompile() {
        this.setDescription("Builds GWT widgetset");
        this.setGroup("web");
    }

    public void generate(String widgetSetClass) {
        this.generateWidgetSetFile = true;
        this.widgetSetClass = widgetSetClass;
    }

    @TaskAction
    public void compileWidgets() {
        File gwtJavaTmp;
        File widgetSetsDirectory;
        if (this.widgetSetsDir == null || this.widgetSetsDir.isEmpty()) {
            this.widgetSetsDir = this.getDefaultBuildDir();
        }
        if (this.widgetSetClass == null || this.widgetSetClass.isEmpty()) {
            this.widgetSetClass = this.getDefaultWidgetSet();
            if (this.widgetSetClass == null) {
                throw new GradleException("Unable to find .gwt.xml file for widgets compilation");
            }
        }
        if ((widgetSetsDirectory = new File(this.widgetSetsDir, "VAADIN/widgetsets")).exists()) {
            FileUtils.deleteQuietly((File)widgetSetsDirectory);
        } else {
            widgetSetsDirectory.mkdirs();
        }
        File gwtTemp = this.getProject().file((Object)"build/tmp/gwt");
        if (!gwtTemp.exists()) {
            gwtTemp.mkdirs();
            gwtTemp.mkdir();
        }
        if ((gwtJavaTmp = this.getProject().file((Object)("build/tmp/" + this.getName()))).exists()) {
            FileUtils.deleteQuietly((File)gwtJavaTmp);
        }
        gwtJavaTmp.mkdirs();
        File gwtWidgetSetTemp = new File(gwtTemp, "widgetset");
        gwtWidgetSetTemp.mkdir();
        List<File> compilerClassPath = this.collectClassPathEntries();
        List<String> gwtCompilerArgs = this.collectCompilerArgs(gwtWidgetSetTemp.getAbsolutePath());
        List<String> gwtCompilerJvmArgs = this.collectCompilerJvmArgs(gwtJavaTmp);
        if (this.generateWidgetSetFile) {
            this.generateWidgetSetXml(compilerClassPath, gwtTemp, this.widgetSetClass);
        }
        if (Os.isFamily((String)"windows") && this.shortClassPath) {
            File classPathFile = this.getProject().file((Object)"build/tmp/compile-widget-set-classpath.dat");
            ClassPathUtil.createClassPathFile(classPathFile, compilerClassPath);
            this.getProject().javaexec(spec -> {
                spec.setMain("io.jmix.gradle.ClassPathCommandLine");
                spec.setClasspath((FileCollection)this.getProject().files(new Object[]{ClassPathUtil.getCommandLineClassPath()}));
                spec.setArgs(ClassPathUtil.getExtendedCommandLineAgs(classPathFile.getAbsolutePath(), "com.google.gwt.dev.Compiler", gwtCompilerArgs));
                spec.setJvmArgs(gwtCompilerJvmArgs);
            });
        } else {
            this.getProject().javaexec(spec -> {
                spec.setMain("com.google.gwt.dev.Compiler");
                spec.setClasspath((FileCollection)this.getProject().files(new Object[]{compilerClassPath}));
                spec.setArgs(gwtCompilerArgs);
                spec.setJvmArgs(gwtCompilerJvmArgs);
            });
        }
        FileUtils.deleteQuietly((File)new File(gwtWidgetSetTemp, "WEB-INF"));
        try {
            FileUtils.copyDirectory((File)gwtWidgetSetTemp, (File)widgetSetsDirectory);
        }
        catch (IOException e) {
            throw new GradleException("Failed to copy compiled widgetset", (Throwable)e);
        }
    }

    protected void generateWidgetSetXml(List<File> compilerClassPath, File gwtTemp, String widgetSetClass) {
        StringBuilder gwtXmlBuilder = new StringBuilder();
        gwtXmlBuilder.append("<module>\n");
        gwtXmlBuilder.append("    <inherits name=\"io.jmix.ui.widget.WidgetSet\"/>\n");
        for (File file : compilerClassPath) {
            if (!file.getName().endsWith(".jar")) continue;
            try {
                FileInputStream is = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    JarInputStream jarStream = new JarInputStream(is);
                    Throwable throwable2 = null;
                    try {
                        String vaadinWidgetsets = this.getVaadinWidgetsets(jarStream);
                        if (vaadinWidgetsets == null || STANDARD_WIDGETSETS.contains(vaadinWidgetsets)) continue;
                        this.getLogger().info("[WidgetsCompile] Including widgets from {}", (Object)vaadinWidgetsets);
                        gwtXmlBuilder.append("    <inherits name=\"").append(vaadinWidgetsets).append("\"/>\n");
                    }
                    catch (Throwable vaadinWidgetsets) {
                        throwable2 = vaadinWidgetsets;
                        throw vaadinWidgetsets;
                    }
                    finally {
                        if (jarStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                jarStream.close();
                            }
                            catch (Throwable vaadinWidgetsets) {
                                throwable2.addSuppressed(vaadinWidgetsets);
                            }
                            continue;
                        }
                        jarStream.close();
                    }
                }
                catch (Throwable jarStream) {
                    throwable = jarStream;
                    throw jarStream;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable jarStream) {
                            throwable.addSuppressed(jarStream);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                throw new GradleException("Unable to read widgets includes", (Throwable)e);
            }
        }
        gwtXmlBuilder.append("</module>");
        File widgetsetTmp = new File(gwtTemp, "widgetset-gen");
        if (widgetsetTmp.exists()) {
            FileUtils.deleteQuietly((File)widgetsetTmp);
        }
        try {
            FileUtils.forceMkdir((File)widgetsetTmp);
        }
        catch (IOException e) {
            throw new GradleException("Unable to create temp dir for generated widgetset file", (Throwable)e);
        }
        int packagePathIndex = widgetSetClass.lastIndexOf(".");
        String packagePath = "";
        String widgetSetFileName = widgetSetClass;
        if (packagePathIndex >= 0) {
            packagePath = widgetSetClass.substring(0, packagePathIndex);
            widgetSetFileName = widgetSetClass.substring(packagePathIndex + 1);
        }
        packagePath = packagePath.replace(".", "/");
        String widgetsetFilePath = widgetSetClass + "." + GWT_XML_EXTENSION;
        if (!packagePath.isEmpty()) {
            widgetsetFilePath = packagePath + "/" + widgetSetFileName + "." + GWT_XML_EXTENSION;
        }
        File file = new File(widgetsetTmp, widgetsetFilePath);
        try {
            File parentDir = file.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            FileUtils.write((File)file, (CharSequence)gwtXmlBuilder.toString(), (Charset)StandardCharsets.UTF_8);
            this.getLogger().info("[WidgetsCompile] Generated widgetset XML {}", (Object)file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new GradleException("Unable to write generated .gwt.xml file: " + file.getAbsolutePath(), (Throwable)e);
        }
        compilerClassPath.add(widgetsetTmp);
    }

    @Nullable
    protected String getVaadinWidgetsets(JarInputStream jarStream) {
        Manifest mf = jarStream.getManifest();
        if (mf != null && mf.getMainAttributes() != null) {
            return mf.getMainAttributes().getValue(VAADIN_WIDGETSETS_MANIFEST_KEY);
        }
        return null;
    }

    @Internal
    protected String getDefaultWidgetSet() {
        SourceSetContainer sourceSets = ((JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        for (SourceSet sourceSet : sourceSets) {
            for (File srcDir : sourceSet.getResources().getSrcDirs()) {
                if (!srcDir.exists()) continue;
                Iterator gwtXmlFiles = FileUtils.iterateFiles((File)srcDir, (String[])new String[]{GWT_XML_EXTENSION}, (boolean)true);
                if (!gwtXmlFiles.hasNext()) continue;
                File gwtXmlFile = (File)gwtXmlFiles.next();
                Path relativePath = srcDir.toPath().relativize(gwtXmlFile.toPath());
                ArrayList<String> names = new ArrayList<String>();
                for (int i = 0; i < relativePath.getNameCount(); ++i) {
                    if (i != relativePath.getNameCount() - 1) {
                        names.add(relativePath.getName(i).toString());
                        continue;
                    }
                    names.add(relativePath.getName(i).toString().replace(".gwt.xml", ""));
                }
                String widgetSet = Joiner.on((String)".").join(names);
                this.getLogger().info("[WidgetsCompile] Found WidgetSet: {} in {}", (Object)widgetSet, (Object)srcDir.getAbsolutePath());
                return widgetSet;
            }
        }
        return null;
    }

    @Override
    @InputFiles
    public FileCollection getSourceFiles() {
        return super.getSourceFiles();
    }

    @OutputDirectory
    public File getOutputDirectory() {
        if (this.widgetSetsDir == null || this.widgetSetsDir.isEmpty()) {
            return new File(this.getDefaultBuildDir());
        }
        return new File(this.widgetSetsDir);
    }

    @Internal
    protected String getDefaultBuildDir() {
        return new File(this.getProject().getBuildDir(), "widgets").getAbsolutePath();
    }

    protected List<File> collectClassPathEntries() {
        StringBuilder sb;
        LinkedHashSet<File> compilerClassPath = new LinkedHashSet<File>();
        Configuration compileConfiguration = (Configuration)this.getProject().getConfigurations().findByName("compileClasspath");
        if (compileConfiguration != null) {
            for (Project dependencyProject : this.collectProjectsWithDependency("vaadin-shared")) {
                SourceSet dependencyMainSourceSet = this.getSourceSet(dependencyProject, "main");
                compilerClassPath.addAll(dependencyMainSourceSet.getJava().getSrcDirs());
                compilerClassPath.addAll(this.getClassesDirs(dependencyMainSourceSet));
                compilerClassPath.add(dependencyMainSourceSet.getOutput().getResourcesDir());
                this.getProject().getLogger().debug(">> Widget set building Module: {}", (Object)dependencyProject.getName());
            }
        }
        SourceSet mainSourceSet = this.getSourceSet(this.getProject(), "main");
        compilerClassPath.addAll(mainSourceSet.getJava().getSrcDirs());
        compilerClassPath.addAll(mainSourceSet.getResources().getSrcDirs());
        compilerClassPath.addAll(this.getClassesDirs(mainSourceSet));
        compilerClassPath.add(mainSourceSet.getOutput().getResourcesDir());
        List compileClassPathArtifacts = StreamSupport.stream(mainSourceSet.getCompileClasspath().spliterator(), false).filter(f -> !f.getName().startsWith("validation-api-2") && !f.getName().startsWith("hibernate-validator")).filter(f -> this.includedArtifact(f.getName()) && !compilerClassPath.contains(f)).collect(Collectors.toList());
        compilerClassPath.addAll(compileClassPathArtifacts);
        Configuration widgetsConfiguration = (Configuration)this.getProject().getConfigurations().findByName("widgets");
        if (widgetsConfiguration != null) {
            List widgetsDeps = widgetsConfiguration.getResolvedConfiguration().getFiles().stream().filter(f -> this.includedArtifact(f.getName()) && !compilerClassPath.contains(f)).collect(Collectors.toList());
            compilerClassPath.addAll(widgetsDeps);
        }
        if (this.getProject().getLogger().isEnabled(LogLevel.DEBUG)) {
            sb = new StringBuilder();
            for (File classPathEntry : compilerClassPath) {
                sb.append('\t').append(classPathEntry.getAbsolutePath()).append('\n');
            }
            this.getProject().getLogger().debug("GWT Compiler ClassPath: \n{}", (Object)sb.toString());
            this.getProject().getLogger().debug("");
        } else if (this.printCompilerClassPath) {
            sb = new StringBuilder();
            for (File classPathEntry : compilerClassPath) {
                sb.append('\t').append(classPathEntry.getAbsolutePath()).append('\n');
            }
            System.out.println("GWT Compiler ClassPath: \n" + sb.toString());
            System.out.println();
        }
        return new ArrayList<File>(compilerClassPath);
    }

    protected List<String> collectCompilerArgs(String warPath) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-war");
        args.add(warPath);
        if (this.strict) {
            args.add("-strict");
        }
        if (this.draft) {
            args.add("-draftCompile");
        }
        if (this.disableCastChecking) {
            args.add("-XdisableCastChecking");
        }
        HashMap<String, String> gwtCompilerArgs = new HashMap<String, String>();
        gwtCompilerArgs.put("-style", this.style);
        gwtCompilerArgs.put("-logLevel", this.logLevel);
        gwtCompilerArgs.put("-localWorkers", String.valueOf(this.workers));
        gwtCompilerArgs.put("-optimize", String.valueOf(this.optimize));
        if (this.compilerArgs != null) {
            for (Map.Entry entry : gwtCompilerArgs.entrySet()) {
                gwtCompilerArgs.put((String)entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        for (Map.Entry entry : gwtCompilerArgs.entrySet()) {
            args.add((String)entry.getKey());
            args.add((String)entry.getValue());
        }
        args.add(this.widgetSetClass);
        if (this.getProject().getLogger().isInfoEnabled()) {
            System.out.println("GWT Compiler args: ");
            System.out.print('\t');
            System.out.println(args);
        }
        return args;
    }

    protected List<String> collectCompilerJvmArgs(File gwtJavaTmp) {
        ArrayList<String> args = new ArrayList<String>(this.compilerJvmArgs);
        args.add(this.xmx);
        args.add(this.xss);
        args.add("-Djava.io.tmpdir=" + gwtJavaTmp.getAbsolutePath());
        if (this.getProject().getLogger().isInfoEnabled()) {
            System.out.println("JVM Args:");
            System.out.print('\t');
            System.out.println(args);
        }
        return args;
    }

    public void setWidgetSetsDir(String widgetSetsDir) {
        this.widgetSetsDir = widgetSetsDir;
    }

    public String getWidgetSetsDir() {
        return this.widgetSetsDir;
    }

    public void setWidgetSetClass(String widgetSetClass) {
        this.widgetSetClass = widgetSetClass;
    }

    public String getWidgetSetClass() {
        return this.widgetSetClass;
    }

    public void setCompilerArgs(Map<String, Object> compilerArgs) {
        this.compilerArgs = compilerArgs;
    }

    public Map<String, Object> getCompilerArgs() {
        return this.compilerArgs;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public void setDisableCastChecking(boolean disableCastChecking) {
        this.disableCastChecking = disableCastChecking;
    }

    public boolean isDisableCastChecking() {
        return this.disableCastChecking;
    }

    public void setOptimize(int optimize) {
        this.optimize = optimize;
    }

    public int getOptimize() {
        return this.optimize;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        return this.style;
    }

    public void setXmx(String xmx) {
        this.xmx = xmx;
    }

    public String getXmx() {
        return this.xmx;
    }

    public void setXss(String xss) {
        this.xss = xss;
    }

    public String getXss() {
        return this.xss;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public boolean isShortClassPath() {
        return this.shortClassPath;
    }

    public void setShortClassPath(boolean shortenClassPath) {
        this.shortClassPath = shortenClassPath;
    }

    public void setWorkers(int workers) {
        this.workers = workers;
    }

    public int getWorkers() {
        return this.workers;
    }

    public void setPrintCompilerClassPath(boolean printCompilerClassPath) {
        this.printCompilerClassPath = printCompilerClassPath;
    }

    public boolean isPrintCompilerClassPath() {
        return this.printCompilerClassPath;
    }
}

