/*
 * Decompiled with CFR 0.152.
 */
package io.jmix.gradle;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ClassPathCommandLine {
    public static void main(String[] args) {
        List<String> classPath = ClassPathCommandLine.readAndRemoveFile(args[0]);
        ClassLoader classLoader = ClassPathCommandLine.buildClassLoader(classPath);
        Thread.currentThread().setContextClassLoader(classLoader);
        System.setProperty("java.class.path", StringUtils.join(classPath, (String)";"));
        ClassPathCommandLine.invokeOriginalMainClass(classLoader, args[1], ClassPathCommandLine.getOriginalArgs(args));
    }

    private static void invokeOriginalMainClass(ClassLoader classLoader, String mainClass, String[] args) {
        try {
            Class<?> cls = classLoader.loadClass(mainClass);
            Method mainMethod = cls.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to run Main-Class:" + mainClass, e);
        }
    }

    private static String[] getOriginalArgs(String[] args) {
        if (args != null) {
            return (String[])ArrayUtils.subarray((Object[])args, (int)2, (int)args.length);
        }
        return new String[0];
    }

    private static ClassLoader buildClassLoader(List<String> classPath) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (String str : classPath) {
                urls.add(new File(str).toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to build classpath:", e);
        }
        return new URLClassLoader(urls.toArray(new URL[0]), null);
    }

    private static List<String> readAndRemoveFile(String path) {
        List lines;
        try {
            lines = FileUtils.readLines((File)new File(path), (Charset)Charset.defaultCharset());
            FileUtils.deleteQuietly((File)new File(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return lines;
    }
}

