/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.validation.emailparameter;

import hudson.Extension;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.util.FormValidation;
import io.jenkins.plugins.util.ValidationUtils;
import io.jenkins.plugins.validation.emailparameter.ValidatingEmailParameterValue;
import javax.annotation.CheckForNull;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ValidatingEmailParameterDefinition
extends ParameterDefinition {
    private String defaultValue;
    private String domain;
    private boolean externalEmail;

    public ValidatingEmailParameterDefinition(String name, String defaultValue, String domain, Boolean externalEmail) {
        this(name, defaultValue, domain, null, externalEmail);
    }

    @DataBoundConstructor
    public ValidatingEmailParameterDefinition(String name, String defaultValue, String domain, String description, Boolean externalEmail) {
        super(name, description);
        this.defaultValue = ValidationUtils.definitionParameter(defaultValue, domain);
        this.domain = domain;
        this.externalEmail = externalEmail;
    }

    @CheckForNull
    public ParameterValue createValue(StaplerRequest staplerRequest, JSONObject jsonObject) {
        JSONObject valid = ValidationUtils.buildParameter(this.domain, this.externalEmail, jsonObject);
        ValidatingEmailParameterValue parameterValue = (ValidatingEmailParameterValue)((Object)staplerRequest.bindJSON(ValidatingEmailParameterValue.class, valid));
        parameterValue.setDescription(this.getDescription());
        parameterValue.setValid(valid.getBoolean(ValidationUtils.Key.IS_VALID.getValue()));
        if (valid.has(ValidationUtils.Key.ERROR.getValue())) {
            parameterValue.setError(valid.getString(ValidationUtils.Key.ERROR.getValue()));
        }
        return parameterValue;
    }

    @CheckForNull
    public ParameterValue createValue(StaplerRequest staplerRequest) {
        return null;
    }

    public ValidatingEmailParameterValue getDefaultParameterValue() {
        return new ValidatingEmailParameterValue(this.getName(), this.getDefaultValue(), this.getDescription());
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDomain() {
        return this.domain;
    }

    public Boolean getExternalEmail() {
        return this.externalEmail;
    }

    @Extension
    @Symbol(value={"email", "emailParam"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Validating Email Parameter";
        }

        public String getHelpFile() {
            return "/plugin/validating-email-parameter/help.html";
        }

        public FormValidation doValidate(@QueryParameter(value="domain") String domain, @QueryParameter(value="value") String value, @QueryParameter(value="externalEmail") Boolean externalEmail) {
            return ValidationUtils.formParameter(domain, value, externalEmail);
        }
    }
}

