/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tics;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.tics.AbstractApiCall;
import hudson.plugins.tics.HtmlTag;
import java.net.ConnectException;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class TicsQualityGate
extends AbstractApiCall {
    private static final String LOGGING_PREFIX = "[TICS Quality Gating] ";
    private static final String GREEN_FLAG = "/plugin/tics/greenFlag.png";
    private static final String RED_FLAG = "/plugin/tics/redFlag.png";
    public final String qualityGateUrl;
    public final boolean failIfQualityGateFails;
    public final Optional<StandardUsernamePasswordCredentials> credentials;
    public final Run<?, ?> run;
    public final TaskListener listener;
    public final String project;
    public final String branch;
    public final String tiobeWebBaseUrl;
    public JsonObject jsonObject;
    public String viewerGateUrl;

    public QualityGateResult createQualityGateResult() throws Exception {
        this.retrieveQualityGateStatus();
        String tableHtml = this.createQualityGateHtml();
        return new QualityGateResult(tableHtml, this.viewerGateUrl);
    }

    public TicsQualityGate(String qualityGateUrl, String tiobeWebBaseUrl, boolean failIfQualityGateFails, String ticsPath, Optional<StandardUsernamePasswordCredentials> credentials, @Nonnull Run<?, ?> run, TaskListener listener) {
        super(LOGGING_PREFIX, listener.getLogger(), credentials);
        String projectAndBranch = ticsPath.split("://")[1];
        this.project = projectAndBranch.split("/")[0];
        this.branch = projectAndBranch.split("/")[1];
        this.qualityGateUrl = qualityGateUrl;
        this.tiobeWebBaseUrl = tiobeWebBaseUrl;
        this.failIfQualityGateFails = failIfQualityGateFails;
        this.credentials = credentials;
        this.run = run;
        this.listener = listener;
    }

    public void retrieveQualityGateStatus() throws Exception {
        String qualityGateUrl1 = this.qualityGateUrl + "?project=" + this.project + "&branch=" + this.branch;
        String body = this.getHttpRequest(qualityGateUrl1);
        this.parseQualityGateJson(body);
    }

    private String getHttpRequest(String url) throws Exception {
        String body;
        HttpGet httpGet = new HttpGet(url);
        try (CloseableHttpClient httpclient = this.createHttpClient();
             CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);){
            body = EntityUtils.toString((HttpEntity)response.getEntity());
            this.throwIfStatusNotOk((HttpResponse)response, body);
        }
        catch (ConnectException e) {
            throw new ConnectException(e.getMessage());
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
        return body;
    }

    private void parseQualityGateJson(String body) {
        try {
            JsonElement jsonElement = new JsonParser().parse(body);
            this.jsonObject = jsonElement.getAsJsonObject();
        }
        catch (JsonSyntaxException ex) {
            throw new RuntimeException("[TICS Quality Gating] Error parsing json: " + body, ex);
        }
    }

    private String createQualityGateHtml() {
        String qualityGateStatus;
        this.viewerGateUrl = this.jsonObject.get("url").getAsString();
        String qualityGateViewerUrl = this.tiobeWebBaseUrl + "/" + this.viewerGateUrl;
        String escapedQualityGateViewerUrl = qualityGateViewerUrl.replace("(", "%28").replace(")", "%29");
        boolean passed = this.jsonObject.get("passed").getAsBoolean();
        String string = qualityGateStatus = passed ? "passed" : "failed";
        if (!passed && this.failIfQualityGateFails) {
            this.run.setResult(Result.FAILURE);
        }
        this.listener.getLogger().println("[TICS Quality Gating]  Quality Gate " + qualityGateStatus + ". Please check the following url for more information: " + escapedQualityGateViewerUrl);
        StringBuilder sb = new StringBuilder();
        sb.append("<p>");
        sb.append("<b>Project:</b> ");
        sb.append(this.project).append("/").append(this.branch);
        sb.append("</p>");
        sb.append("<p>");
        sb.append(this.jsonObject.get("message").getAsString());
        sb.append("</p>");
        JsonArray gates = this.jsonObject.getAsJsonArray("gates");
        sb.append(this.qualityGateSummary(gates));
        return sb.toString();
    }

    private String qualityGateSummary(JsonArray gates) {
        String greenFlagElement = "<img src='/plugin/tics/greenFlag.png' width='30' height='20'>";
        String redFlagElement = "<img src='/plugin/tics/redFlag.png' width='30' height='20'>";
        StringBuilder sb = new StringBuilder();
        for (JsonElement gate : gates) {
            String gateName = gate.getAsJsonObject().get("name").getAsString();
            JsonArray gateConditions = gate.getAsJsonObject().getAsJsonArray("conditions");
            int failedConditionsNr = 0;
            int successfulConditionsNr = 0;
            for (JsonElement condition : gateConditions) {
                if (condition.getAsJsonObject().get("passed").getAsBoolean()) {
                    ++successfulConditionsNr;
                    continue;
                }
                ++failedConditionsNr;
            }
            HtmlTag div = HtmlTag.from("div").attr("style", "margin-top: 15px");
            sb.append(div.open());
            sb.append("<div style='float: right; display: inline;'>").append("<img src='/plugin/tics/redFlag.png' width='30' height='20'>").append(" ").append(failedConditionsNr).append(" failed ").append("<img style='margin-left: 5px' src='/plugin/tics/greenFlag.png' width='30' height='20'>").append(" ").append(successfulConditionsNr).append(" passed").append("</div>");
            sb.append("<h4 style='margin-bottom: 6px'>").append(gateName).append("</h4>");
            sb.append(div.close());
            HtmlTag table = HtmlTag.from("table").attr("id", "quality-gate").attr("style", "border-spacing: 0px").attr("style", "border-collapse: collapse").attr("style", "margin-bottom: 20px");
            sb.append(table.open());
            sb.append("<thead>");
            sb.append("<tr>");
            sb.append("</tr>");
            sb.append("</thead>");
            sb.append("<colgroup><col><col style='width: 100%'><col></colgroup>");
            sb.append("<tbody>");
            for (JsonElement condition : gateConditions) {
                boolean didConditionPass = condition.getAsJsonObject().get("passed").getAsBoolean();
                String conditionFlag = didConditionPass ? "<img src='/plugin/tics/greenFlag.png' width='30' height='20'>" : "<img src='/plugin/tics/redFlag.png' width='30' height='20'>";
                String conditionMessage = condition.getAsJsonObject().get("message").getAsString();
                HtmlTag tr = HtmlTag.from("tr").attr("style", "border-top: 1px solid #CCC");
                sb.append(tr.open());
                HtmlTag td = HtmlTag.from("td").attr("style", "padding-top: 2px").attr("style", "background-color: #FFF").attr("style", "padding: 4px 5px ");
                sb.append(td.open());
                sb.append(conditionFlag);
                sb.append(td.close());
                td = td.attr("style", "text-align: left");
                sb.append(td.open());
                sb.append(conditionMessage);
                sb.append(td.close());
            }
            sb.append("</tbody>");
            sb.append("</table>");
        }
        return sb.toString();
    }

    public static class QualityGateResult {
        public String tableHtml;
        public String viewerGateUrl;

        public QualityGateResult(String html, String viewerGateUrl) {
            this.tableHtml = html;
            this.viewerGateUrl = viewerGateUrl;
        }
    }
}

