/*
 * Decompiled with CFR 0.152.
 */
package com.thycotic.secrets.jenkins;

import com.thycotic.secrets.jenkins.ServerConfiguration;
import com.thycotic.secrets.jenkins.ServerSecret;
import com.thycotic.secrets.jenkins.UserCredentials;
import com.thycotic.secrets.server.spring.Secret;
import com.thycotic.secrets.server.spring.SecretServer;
import com.thycotic.secrets.server.spring.SecretServerFactoryBean;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import jenkins.tasks.SimpleBuildWrapper;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class ServerBuildWrapper
extends SimpleBuildWrapper {
    private static final String USERNAME_PROPERTY = "secret_server.oauth2.username";
    private static final String PASSWORD_PROPERTY = "secret_server.oauth2.password";
    private static final String API_ROOT_URL_PROPERTY = "secret_server.api_root_url";
    private static final String OAUTH2_TOKEN_URL_PROPERTY = "secret_server.oauth2.token_url";
    private List<ServerSecret> secrets;

    @DataBoundConstructor
    public ServerBuildWrapper(List<ServerSecret> secrets) {
        this.secrets = secrets;
    }

    public List<ServerSecret> getSecrets() {
        return this.secrets;
    }

    @DataBoundSetter
    public void setSecrets(List<ServerSecret> secrets) {
        this.secrets = secrets;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        ServerConfiguration configuration = (ServerConfiguration)((Object)ExtensionList.lookupSingleton(ServerConfiguration.class));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(API_ROOT_URL_PROPERTY, configuration.getAPIUrl());
        properties.put(OAUTH2_TOKEN_URL_PROPERTY, configuration.getTokenUrl());
        this.secrets.forEach(serverSecret -> {
            String overrideBaseURL = serverSecret.getBaseUrl();
            String overrideUserCredentialId = serverSecret.getCredentialId();
            if (StringUtils.isNotBlank((String)overrideBaseURL)) {
                properties.put(API_ROOT_URL_PROPERTY, overrideBaseURL + configuration.getApiPathUri());
                properties.put(OAUTH2_TOKEN_URL_PROPERTY, overrideBaseURL + configuration.getTokenPathUri());
            }
            UserCredentials credential = StringUtils.isNotBlank((String)overrideUserCredentialId) ? UserCredentials.get(overrideUserCredentialId, null) : UserCredentials.get(configuration.getCredentialId(), null);
            assert (credential != null);
            properties.put(USERNAME_PROPERTY, credential.getUsername());
            properties.put(PASSWORD_PROPERTY, credential.getPassword().getPlainText());
            AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext();
            applicationContext.getEnvironment().getPropertySources().addLast((PropertySource)new MapPropertySource("properties", properties));
            applicationContext.registerBean(SecretServerFactoryBean.class, new BeanDefinitionCustomizer[0]);
            applicationContext.refresh();
            Secret secret = ((SecretServer)applicationContext.getBean(SecretServer.class)).getSecret(serverSecret.getId());
            secret.getFields().forEach(field -> serverSecret.getMappings().forEach(mapping -> {
                if (mapping.getField().equalsIgnoreCase(field.getFieldName())) {
                    context.env(StringUtils.trimToEmpty((String)configuration.getEnvironmentVariablePrefix()) + mapping.getEnvironmentVariable(), field.getValue());
                }
            }));
            applicationContext.close();
        });
    }

    @Extension
    @Symbol(value={"withSecretServer"})
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Use Thycotic Secret Server Secrets";
        }
    }
}

