/*
 * Decompiled with CFR 0.152.
 */
package com.thycotic.secrets.jenkins;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.thycotic.secrets.jenkins.ClientSecret;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import jenkins.model.GlobalConfiguration;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;

@Extension
@Symbol(value={"devOpsSecretsVault"})
public class VaultConfiguration
extends GlobalConfiguration {
    public static final String DEFAULT_ENVIRONMENT_VARIABLE_PREFIX = "DSV_";
    public static final String DEFAULT_TLD = "com";
    private String credentialId;
    private String tenant;
    private String tld = "com";
    private String environmentVariablePrefix = "DSV_";

    public static VaultConfiguration get() {
        return (VaultConfiguration)((Object)ExtensionList.lookupSingleton(VaultConfiguration.class));
    }

    public VaultConfiguration() {
        this.load();
    }

    public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item item) {
        return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, item, ClientSecret.class);
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    @DataBoundSetter
    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
        this.save();
    }

    public String getEnvironmentVariablePrefix() {
        return this.environmentVariablePrefix;
    }

    @DataBoundSetter
    public void setEnvironmentVariablePrefix(String environmentVariablePrefix) {
        this.environmentVariablePrefix = environmentVariablePrefix;
        this.save();
    }

    public String getTenant() {
        return this.tenant;
    }

    @DataBoundSetter
    public void setTenant(String tenant) {
        this.tenant = tenant;
        this.save();
    }

    public String getTld() {
        return this.tld;
    }

    @DataBoundSetter
    public void setTld(String tld) {
        this.tld = tld;
        this.save();
    }
}

