/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.springconfig;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.springconfig.SpringProfilesFolderProperty;
import org.jenkinsci.plugins.springconfig.SpringProfilesJobProperty;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class SpringProfilesStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public SpringProfilesStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new SpringProfileExecution(context, this);
    }

    public static class SpringProfileExecution
    extends SynchronousStepExecution<List<String>> {
        private final SpringProfilesStep step;

        protected SpringProfileExecution(@Nonnull StepContext context, SpringProfilesStep step) {
            super(context);
            this.step = step;
        }

        protected List<String> run() {
            Job job = ((Run)this.getContext().get(Run.class)).getParent();
            List<String> retrieveSpringProfilesFromJobConfig = SpringProfilesJobProperty.retrieveSpringProfilesFromJobConfig(job);
            List<String> retrievedSpringProfilesFromSingleFolder = SpringProfilesFolderProperty.retrieveSpringProfileFromFolderConfig(job);
            return Stream.of(retrievedSpringProfilesFromSingleFolder, retrieveSpringProfilesFromJobConfig).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class);
        }

        public String getFunctionName() {
            return "springProfiles";
        }

        public String getDisplayName() {
            return "A step to retrieve spring profiles defined in Job";
        }
    }
}

