/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.springconfig;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.jenkinsci.plugins.springconfig.SpringProfilesStore;

public class SpringProfilesLoader {
    private static final Logger log = Logger.getLogger(SpringProfilesLoader.class.getName());

    static List<String> retrieveSpringProfilesFromStore(@NonNull SpringProfilesStore store) {
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        return Optional.ofNullable(store.getSpringProfiles()).filter(profile -> !Strings.isNullOrEmpty((String)profile)).map(profile -> Arrays.stream(profile.split(",")).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }
}

