/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.springconfig;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.springconfig.Messages;
import org.jenkinsci.plugins.springconfig.SpringProfilesLoader;
import org.jenkinsci.plugins.springconfig.SpringProfilesStore;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class SpringProfilesFolderProperty<C extends AbstractFolder<?>>
extends AbstractFolderProperty<AbstractFolder<?>>
implements SpringProfilesStore {
    private static final Logger log = Logger.getLogger(SpringProfilesFolderProperty.class.getName());
    @DataBoundSetter
    private String springProfiles = "";

    @DataBoundConstructor
    public SpringProfilesFolderProperty() {
        log.log(Level.FINER, "Instantiating new SpringProfileFolderProperty\n");
    }

    public AbstractFolderProperty<?> reconfigure(StaplerRequest request, JSONObject formData) throws Descriptor.FormException {
        if (formData == null) {
            return null;
        }
        this.springProfiles = formData.getString("springProfiles");
        return this;
    }

    static List<String> retrieveSpringProfileFromFolderConfig(Job job) {
        ArrayList<String> springProfiles = new ArrayList<String>();
        ItemGroup parent = job.getParent();
        while (parent != null) {
            if (parent instanceof AbstractFolder) {
                List<String> folderProfiles = SpringProfilesFolderProperty.retrieveSpringProfilesFromSingleFolder((AbstractFolder)parent);
                springProfiles.addAll(0, folderProfiles);
            } else if (parent instanceof Jenkins) break;
            if (parent instanceof Item) {
                parent = ((Item)parent).getParent();
                continue;
            }
            parent = null;
        }
        return springProfiles;
    }

    static List<String> retrieveSpringProfilesFromSingleFolder(AbstractFolder folder) {
        return Optional.ofNullable(folder).map(thisFolder -> thisFolder.getProperties().get(SpringProfilesFolderProperty.class)).map(SpringProfilesFolderProperty.class::cast).map(SpringProfilesLoader::retrieveSpringProfilesFromStore).orElseGet(Collections::emptyList);
    }

    @Override
    public String getSpringProfiles() {
        return this.springProfiles;
    }

    public void setSpringProfiles(String springProfiles) {
        this.springProfiles = springProfiles;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractFolderPropertyDescriptor {
        @Nonnull
        public String getDisplayName() {
            return Messages.display_spring_profiles();
        }
    }
}

