/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.springconfig;

import hudson.model.Api;
import hudson.model.Run;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import jenkins.model.RunAction2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class SpringConfigAction
implements RunAction2 {
    private Run run;
    private final Map<String, Map<String, String>> allProperties = new HashMap<String, Map<String, String>>();

    public void addProperties(String profiles, Map<String, String> properties) {
        this.allProperties.put(profiles, properties);
    }

    public void onAttached(Run<?, ?> r) {
        this.run = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.run = r;
    }

    @CheckForNull
    public String getIconFileName() {
        return "/plugin/spring-config/images/spring-framework.png";
    }

    @CheckForNull
    public String getDisplayName() {
        return "Spring Config";
    }

    @CheckForNull
    public String getUrlName() {
        return "springconfig";
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    @Exported(visibility=2)
    public Map<String, Map<String, String>> getProperties() {
        return this.allProperties;
    }

    public List<ProfileConfig> getAllProperties() {
        return this.allProperties.entrySet().stream().map(profileProperties -> {
            Map properties = (Map)profileProperties.getValue();
            List<KeyValue> propertiesAsList = properties.entrySet().stream().map(property -> KeyValue.builder().key((String)property.getKey()).value(property.getValue()).build()).sorted(Comparator.comparing(KeyValue::getKey)).collect(Collectors.toList());
            String profiles = (String)profileProperties.getKey();
            return ProfileConfig.builder().profiles(profiles).properties(propertiesAsList).build();
        }).collect(Collectors.toList());
    }

    public static class KeyValue {
        private String key;
        private Object value;

        KeyValue(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public static KeyValueBuilder builder() {
            return new KeyValueBuilder();
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public static class KeyValueBuilder {
            private String key;
            private Object value;

            KeyValueBuilder() {
            }

            public KeyValueBuilder key(String key) {
                this.key = key;
                return this;
            }

            public KeyValueBuilder value(Object value) {
                this.value = value;
                return this;
            }

            public KeyValue build() {
                return new KeyValue(this.key, this.value);
            }

            public String toString() {
                return "SpringConfigAction.KeyValue.KeyValueBuilder(key=" + this.key + ", value=" + this.value + ")";
            }
        }
    }

    public static class ProfileConfig {
        private String profiles;
        private List<KeyValue> properties;

        ProfileConfig(String profiles, List<KeyValue> properties) {
            this.profiles = profiles;
            this.properties = properties;
        }

        public static ProfileConfigBuilder builder() {
            return new ProfileConfigBuilder();
        }

        public void setProfiles(String profiles) {
            this.profiles = profiles;
        }

        public void setProperties(List<KeyValue> properties) {
            this.properties = properties;
        }

        public String getProfiles() {
            return this.profiles;
        }

        public List<KeyValue> getProperties() {
            return this.properties;
        }

        public static class ProfileConfigBuilder {
            private String profiles;
            private List<KeyValue> properties;

            ProfileConfigBuilder() {
            }

            public ProfileConfigBuilder profiles(String profiles) {
                this.profiles = profiles;
                return this;
            }

            public ProfileConfigBuilder properties(List<KeyValue> properties) {
                this.properties = properties;
                return this;
            }

            public ProfileConfig build() {
                return new ProfileConfig(this.profiles, this.properties);
            }

            public String toString() {
                return "SpringConfigAction.ProfileConfig.ProfileConfigBuilder(profiles=" + this.profiles + ", properties=" + this.properties + ")";
            }
        }
    }
}

