/*
 * Decompiled with CFR 0.152.
 */
package cz.mendelu.xotradov;

import cz.mendelu.xotradov.PermissionHandler;
import cz.mendelu.xotradov.UnsafeResetAction;
import hudson.Extension;
import hudson.model.RootAction;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class ResetAction
implements RootAction {
    private static Logger logger = Logger.getLogger(ResetAction.class.getName());

    @RequirePOST
    public void doReset(StaplerRequest request, StaplerResponse response) {
        if (!Jenkins.get().hasPermission(PermissionHandler.SIMPLE_QUEUE_RESET_PERMISSION)) {
            return;
        }
        UnsafeResetAction.resetImpl(request, response);
    }

    @CheckForNull
    public String getIconFileName() {
        if (Jenkins.get().hasPermission(PermissionHandler.SIMPLE_QUEUE_RESET_PERMISSION)) {
            return "/plugin/simple-queue/images/reset_64.png";
        }
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        if (Jenkins.get().hasPermission(PermissionHandler.SIMPLE_QUEUE_RESET_PERMISSION)) {
            return "Reset Simple-Queue";
        }
        return null;
    }

    @CheckForNull
    public String getUrlName() {
        if (Jenkins.get().hasPermission(PermissionHandler.SIMPLE_QUEUE_RESET_PERMISSION)) {
            return "simpleQueueReset";
        }
        return null;
    }
}

